/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.toolbox;

import com.neutronio.astrax.editor.toolbox.EditorToolBase;
import com.neutronio.astrax.ui.editor.EditorCell;
import com.neutronio.astrax.util.collections.Grid;
import java.util.ArrayList;
import java.util.List;

public class InspectionTool
extends EditorToolBase {
    protected EditorCell selectedCell;
    private List<InspectionToolListener> listeners = new ArrayList<InspectionToolListener>();

    public InspectionTool() {
        super("inspect", "icon_inline_info");
    }

    public void addListener(InspectionToolListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public void doAction(Grid<EditorCell> data) {
        this.selectedCell = data.get(this.getCanvasTile().location.x, this.getCanvasTile().location.y);
        for (InspectionToolListener listener : this.listeners) {
            listener.onInspectCell(this.selectedCell);
        }
    }

    public static interface InspectionToolListener {
        public void onInspectCell(EditorCell var1);
    }
}

