/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.toolbox;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.editor.toolbox.EditorToolBase;
import com.neutronio.astrax.ui.editor.EditorCell;
import com.neutronio.astrax.util.Vector2i;
import com.neutronio.astrax.util.collections.Grid;
import java.util.List;

public class PaintTool
extends EditorToolBase {
    public String icon = "icon_inline_brush";
    private Color selectedColor;
    private PaintTooLListener paintTooLListener;

    public PaintTool() {
        super("paint", "icon_inline_brush");
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    @Override
    public void doAction(Grid<EditorCell> data) {
        if (this.selectedColor == null) {
            return;
        }
        if (!data.isEmpty(this.getCanvasTile().location.x, this.getCanvasTile().location.y)) {
            data.get((int)this.getCanvasTile().location.x, (int)this.getCanvasTile().location.y).color = this.selectedColor;
            if (this.paintTooLListener != null) {
                this.paintTooLListener.onPainted(this.getCanvasTile().location.x, this.getCanvasTile().location.y, this.selectedColor);
            }
        }
    }

    public void resetPaintSelected(Grid<EditorCell> data, List<Vector2i> activeSelection) {
        for (Vector2i coordinates : activeSelection) {
            if (data.isEmpty(coordinates.x, coordinates.y)) continue;
            data.get((int)coordinates.x, (int)coordinates.y).color = data.get((int)coordinates.x, (int)coordinates.y).module.color.cpy();
        }
        if (this.paintTooLListener != null) {
            this.paintTooLListener.onResetPaint(activeSelection);
        }
    }

    public void paintSelected(Grid<EditorCell> data, List<Vector2i> activeSelection) {
        if (this.selectedColor == null) {
            return;
        }
        for (Vector2i coordinates : activeSelection) {
            if (data.isEmpty(coordinates.x, coordinates.y)) continue;
            data.get((int)coordinates.x, (int)coordinates.y).color = this.selectedColor;
        }
        if (this.paintTooLListener != null) {
            this.paintTooLListener.onPaintAll(activeSelection, this.selectedColor);
        }
    }

    public PaintTooLListener getPaintTooLListener() {
        return this.paintTooLListener;
    }

    public void setPaintTooLListener(PaintTooLListener paintTooLListener) {
        this.paintTooLListener = paintTooLListener;
    }

    public static interface PaintTooLListener {
        public void onPainted(int var1, int var2, Color var3);

        public void onResetPaint(List<Vector2i> var1);

        public void onPaintAll(List<Vector2i> var1, Color var2);
    }
}

