/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.toolbox;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.editor.toolbox.EditorToolBase;
import com.neutronio.astrax.ui.editor.EditorCell;
import com.neutronio.astrax.util.Vector2i;
import com.neutronio.astrax.util.collections.Grid;
import java.util.ArrayList;
import java.util.List;

public class SelectionTool
extends EditorToolBase {
    private List<Vector2i> selected = new ArrayList<Vector2i>();

    public SelectionTool() {
        super("select", "icon_inline_select");
    }

    public void inverseSelection(int tileWidth, int tileHeight) {
        ArrayList<Vector2i> inverse = new ArrayList<Vector2i>();
        for (int x = 0; x < tileWidth; ++x) {
            for (int y = 0; y < tileHeight; ++y) {
                inverse.add(new Vector2i(x, y));
            }
        }
        for (Vector2i selectedTile : this.selected) {
            inverse.remove(selectedTile);
        }
        this.selected.clear();
        this.selected.addAll(inverse);
    }

    public void selectBlocks(SatelliteGrid satelliteGrid) {
        for (int x = 0; x < satelliteGrid.getData().getWidth(); ++x) {
            for (int y = 0; y < satelliteGrid.getData().getHeight(); ++y) {
                if (satelliteGrid.getData().isEmpty(x, y)) continue;
                this.selected.add(new Vector2i(x, y));
            }
        }
    }

    public void deselectAll() {
        this.selected.clear();
    }

    public void select(int x, int y) {
        this.selected.add(new Vector2i(x, y));
    }

    public void deselect(int x, int y) {
        this.selected.remove(new Vector2i(x, y));
    }

    public boolean isSelected(int x, int y) {
        return this.selected.contains(new Vector2i(x, y));
    }

    public List<Vector2i> getSelected() {
        return this.selected;
    }

    public void onClicked(int x, int y) {
        if (this.isSelected(x, y)) {
            this.deselect(x, y);
        } else {
            this.select(x, y);
        }
    }

    @Override
    public void doAction(Grid<EditorCell> data) {
        if (this.isSelected(this.getCanvasTile().location.x, this.getCanvasTile().location.y)) {
            this.deselect(this.getCanvasTile().location.x, this.getCanvasTile().location.y);
        } else {
            this.select(this.getCanvasTile().location.x, this.getCanvasTile().location.y);
        }
    }
}

