/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.neutronio.astrax.gfx.AnimationStateGraphics;
import java.util.ArrayList;
import java.util.List;

public class AnimationGroup {
    protected AnimationStateGraphics animationStateGraphics;
    protected List<Image> instances = new ArrayList<Image>();
    protected TextureRegionDrawable currentDrawable = null;
    protected float time = (float)Math.random();

    public AnimationGroup() {
        this.currentDrawable = new TextureRegionDrawable();
    }

    public void setAnimation(Animation ... animations) {
        this.animationStateGraphics = new AnimationStateGraphics(animations);
    }

    public void addRenderPosition(Color tint, float x, float y, float rotation, float scale) {
        Image engineInstance = new Image();
        engineInstance.setSize(this.animationStateGraphics.getCurrentFrame().getRegionWidth(), this.animationStateGraphics.getCurrentFrame().getRegionHeight());
        engineInstance.setDrawable(new TextureRegionDrawable(this.animationStateGraphics.getCurrentFrame()));
        engineInstance.setOrigin(1);
        engineInstance.setPosition(x, y, 1);
        engineInstance.setRotation(rotation);
        engineInstance.setColor(tint);
        this.instances.add(engineInstance);
    }

    public void updateState(float currentState) {
        this.animationStateGraphics.setCurrentState(currentState);
    }

    public void draw(Batch batch, float parentAlpha) {
        this.time += Gdx.graphics.getDeltaTime();
        for (Image image : this.instances) {
            if (this.animationStateGraphics == null || image == null) continue;
            this.animationStateGraphics.update(this.time);
            this.currentDrawable.setRegion(this.animationStateGraphics.getCurrentFrame());
            image.setDrawable(this.currentDrawable);
            image.draw(batch, parentAlpha);
        }
    }
}

