/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.gfx.AbstractAnimationGraphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AnimationStateGraphics
extends AbstractAnimationGraphics<List<Animation<TextureAtlas.AtlasRegion>>> {
    private float currentState = 0.0f;

    public AnimationStateGraphics(Animation<TextureAtlas.AtlasRegion> ... animations) {
        if (animations.length == 0) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Must include at least one animation!");
        }
        this.animation = new ArrayList();
        for (Animation<TextureAtlas.AtlasRegion> animation : animations) {
            ((List)this.animation).add(animation);
        }
        this.currentFrame = (TextureAtlas.AtlasRegion)((Animation)((List)this.animation).get(0)).getKeyFrame(0.0f);
    }

    protected AnimationStateGraphics(List<Animation<TextureAtlas.AtlasRegion>> animations) {
        if (animations.size() == 0) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Must include at least one animation!");
        }
        this.animation = new ArrayList();
        for (Animation<TextureAtlas.AtlasRegion> animation : animations) {
            ((List)this.animation).add(animation);
        }
        this.currentFrame = (TextureAtlas.AtlasRegion)((Animation)((List)this.animation).get(0)).getKeyFrame(0.0f);
    }

    public AnimationStateGraphics copy() {
        AnimationStateGraphics copy = new AnimationStateGraphics((List)this.animation);
        copy.setCurrentState(this.currentState);
        return copy;
    }

    public float getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(float state) {
        this.currentState = MathUtils.clamp(Math.abs(state), 0.0f, 100.0f);
    }

    public Animation<TextureAtlas.AtlasRegion> getCurrentAnimation() {
        int index = (int)Math.floor((float)(((List)this.animation).size() - 1) / 99.0f * this.currentState);
        return (Animation)((List)this.animation).get(index);
    }

    @Override
    public void update(float currentTime) {
        Animation<TextureAtlas.AtlasRegion> currentAnimation = this.getCurrentAnimation();
        TextureAtlas.AtlasRegion keyFrame = currentAnimation.getKeyFrame(currentTime);
        if (!Objects.equals(keyFrame, this.currentFrame) && keyFrame != null) {
            this.currentFrame = keyFrame;
        }
    }
}

