/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidSettings;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.particles.AnimatedParticleEmitter;
import com.neutronio.astrax.sfx.ShuffleSound;
import com.neutronio.astrax.util.animation.Tweening;

public class AsteroidGraphics
extends Group {
    private AsteroidSettings graphicsSettings;
    private AstraXRenderContext astraXRenderContext;
    protected Array<TextureAtlas.AtlasRegion> body;
    private Image bodyImage;
    private TextureRegionDrawable bodyDrawable;
    protected Array<TextureAtlas.AtlasRegion> resource;
    private Image resourceImage;
    private TextureRegionDrawable resourceDrawable;
    protected AnimatedParticleEmitter particleEmitter;
    protected AnimatedParticleEmitter resourceParticleEmitter;
    private boolean selected = false;
    private float discoveredFactor = 0.0f;
    private float resourceFactor = 0.0f;
    protected int state = 0;
    protected ShuffleSound sound = new ShuffleSound();

    public AsteroidGraphics() {
        this.sound.setSoundCount(2);
        this.sound.setSoundID("rock");
        this.bodyDrawable = new TextureRegionDrawable();
        this.resourceDrawable = new TextureRegionDrawable();
        this.bodyImage = new Image(this.bodyDrawable);
        this.bodyImage.setOrigin(32.0f, 32.0f);
        this.bodyImage.setSize(64.0f, 64.0f);
        this.resourceImage = new Image(this.resourceDrawable);
        this.resourceImage.setOrigin(32.0f, 32.0f);
        this.resourceImage.setSize(64.0f, 64.0f);
        this.setOrigin(32.0f, 32.0f);
        this.setSize(64.0f, 64.0f);
        this.addActor(this.bodyImage);
    }

    public Image getBodyImage() {
        return this.bodyImage;
    }

    public Image getResourceImage() {
        return this.resourceImage;
    }

    public void setDiscoveredFactor(float discoveredFactor) {
        this.discoveredFactor = discoveredFactor;
    }

    public void setResourceFactor(float resourceFactor) {
        this.resourceFactor = resourceFactor;
    }

    public void setSettings(AsteroidSettings graphicsSettings) {
        this.graphicsSettings = graphicsSettings;
        this.onStateChanged();
    }

    public void rumble() {
        Action rumbleXY = Tweening.getAsteroidCrackRumbleXY(this.getX(), this.getY());
        this.addAction(rumbleXY);
    }

    public void crackOpen() {
        this.state = MathUtils.clamp(++this.state, 0, this.body.size - 1);
        this.onStateChanged();
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    public void toggleSelected() {
        this.selected = !this.selected;
    }

    public void onStartMining() {
        this.particleEmitter.stop();
        this.particleEmitter.start();
        this.resourceParticleEmitter.stop();
        this.resourceParticleEmitter.start();
    }

    public void onStopMining() {
        this.particleEmitter.stop();
        this.resourceParticleEmitter.stop();
    }

    public void onResourceMined() {
        this.rumble();
        float newState = (float)(this.body.size - 1) * (1.0f - this.resourceFactor);
        if (Math.round(newState) != this.state) {
            this.state = MathUtils.clamp(++this.state, 0, this.body.size - 1);
            this.onStateChanged();
        }
    }

    public void setAstraXRenderContext(AstraXRenderContext astraXRenderContext) {
        this.astraXRenderContext = astraXRenderContext;
    }

    private void onStateChanged() {
        if (this.state != 0) {
            AstraXApp.astraX.getSfxSoundManager().playSound(this.sound);
        }
        this.bodyDrawable.setRegion(this.body.get(this.state));
        if (this.graphicsSettings.bodyColor != null) {
            this.bodyImage.setColor(this.graphicsSettings.bodyColor);
            this.particleEmitter.setColor(this.graphicsSettings.bodyColor);
        }
        if (!this.resource.isEmpty() && this.resource.get(this.state) != null) {
            this.resourceDrawable.setRegion(this.resource.get(this.state));
            if (this.graphicsSettings.resourceColor != null) {
                this.resourceImage.setColor(this.graphicsSettings.resourceColor);
                this.resourceParticleEmitter.setColor(this.graphicsSettings.resourceColor);
            }
            this.addActor(this.resourceImage);
        } else {
            this.particleEmitter.setColor(Color.WHITE);
            this.resourceParticleEmitter.setColor(Color.WHITE);
            this.resourceImage.setColor(Color.WHITE);
            this.resourceImage.remove();
        }
        if (!this.particleEmitter.hasParent()) {
            this.particleEmitter.setPosition(32.0f, 32.0f);
            this.addActor(this.particleEmitter);
        }
        if (!this.resourceParticleEmitter.hasParent()) {
            this.resourceParticleEmitter.setPosition(32.0f, 32.0f);
            this.addActor(this.resourceParticleEmitter);
            this.resourceParticleEmitter.toFront();
        }
    }

    @Override
    protected void drawChildren(Batch batch, float parentAlpha) {
        super.drawChildren(batch, parentAlpha);
        if (this.selected) {
            float x = -(this.bodyImage.getPrefWidth() + 30.0f) / 2.0f + this.bodyImage.getPrefWidth() / 2.0f;
            float y = -(this.bodyImage.getPrefHeight() + 30.0f) / 2.0f + this.bodyImage.getPrefHeight() / 2.0f;
            float width = this.bodyImage.getPrefWidth() + 30.0f;
            float height = this.bodyImage.getPrefHeight() + 30.0f;
            this.astraXRenderContext.getShapeTargetor().render(this.astraXRenderContext.getShapeDrawer(), x, y, width, height, Gdx.graphics.getDeltaTime());
            this.astraXRenderContext.getCircleBarRenderer().render(this.astraXRenderContext.getShapeDrawer(), Color.BROWN, x, y, width, height, 0.0f, this.resourceFactor);
        }
    }
}

