/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidSettings;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.app.repository.AnimatedParticleEmitterRepository;
import com.neutronio.astrax.gfx.AnimatedParticleEmitterSettings;
import com.neutronio.astrax.gfx.AsteroidGraphics;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.factories.ParticleFactory;

public class AsteroidGraphicsFactory
extends AbstractFactory
implements GenericFactory<AsteroidGraphics, AsteroidSettings> {
    private AstraXRenderContext worldRenderContext;

    public AsteroidGraphicsFactory() {
    }

    public AsteroidGraphicsFactory(DataContext dataContext) {
        super(dataContext);
    }

    public void setWorldRenderContext(AstraXRenderContext worldRenderContext) {
        this.worldRenderContext = worldRenderContext;
    }

    @Override
    public AsteroidGraphics create(AsteroidSettings asteroidSettings) {
        ParticleFactory particleFactory = AstraXApp.astraX.getFactoryByClass(ParticleFactory.class);
        AnimatedParticleEmitterRepository particleEmitterRepository = AstraXApp.astraX.getRepository(AnimatedParticleEmitterRepository.class);
        AsteroidGraphics graphics = new AsteroidGraphics();
        graphics.setAstraXRenderContext(this.worldRenderContext);
        graphics.body = this.dataPack.getTextureAtlas().findRegions(asteroidSettings.baseImage);
        graphics.resource = this.dataPack.getTextureAtlas().findRegions(asteroidSettings.resourceImage);
        graphics.particleEmitter = particleFactory.create((AnimatedParticleEmitterSettings)particleEmitterRepository.find(asteroidSettings.particleEmitter));
        graphics.resourceParticleEmitter = particleFactory.create((AnimatedParticleEmitterSettings)particleEmitterRepository.find(asteroidSettings.resourceParticleEmitter));
        graphics.setSettings(asteroidSettings);
        return graphics;
    }
}

