/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.hud.CircleBar;
import com.neutronio.astrax.ui.hud.ShapeTargetor;
import java.util.Objects;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class AstraXRenderContext {
    private ShapeDrawer shapeDrawer;
    private ShapeTargetor shapeTargetor;
    private CircleBar circleBarRenderer;

    public AstraXRenderContext(ComponentFactory componentFactory, Stage stage, TextureRegion textureRegion) {
        this.shapeDrawer = new ShapeDrawer(stage.getBatch(), textureRegion);
        this.shapeTargetor = new ShapeTargetor(componentFactory.getSkin());
        this.circleBarRenderer = new CircleBar(componentFactory.getSkin());
    }

    public void assertValid(Batch batch) {
        if (!Objects.equals(this.shapeDrawer.getBatch(), batch)) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "ShapeDrawer Batch is not the same as specified batch! Check your init code");
        }
    }

    public CircleBar getCircleBarRenderer() {
        return this.circleBarRenderer;
    }

    public ShapeTargetor getShapeTargetor() {
        return this.shapeTargetor;
    }

    public ShapeDrawer getShapeDrawer() {
        return this.shapeDrawer;
    }
}

