/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.ui.commons.widgets.Zoomable;
import com.neutronio.astrax.util.AstraXUtil;
import java.util.logging.Logger;

public class PanningCamera
implements Zoomable {
    private static float maxZoom = 10.0f;
    private static float minZoom = 2.5f;
    private Logger logger = Logger.getLogger(PanningCamera.class.getSimpleName());
    private float constantRumbleStrength = 0.0f;
    private float rumbleFactor = 0.0f;
    private float xDisplacement = 0.0f;
    private float yDisplacement = 0.0f;
    private Vector2 currentFocusPos = new Vector2();
    private Vector2 currentFocusPosInterpolated = new Vector2();
    private Vector2 offset = new Vector2();
    private Vector2 offsetInterpolated = new Vector2();
    private float targetZoom = 1.0f;
    private Targetable focusedActor;
    private OrthographicCamera stageCamera;
    private OrthographicCamera backGroundCamera;

    public PanningCamera(OrthographicCamera stageCamera, OrthographicCamera backGroundCamera) {
        this.stageCamera = stageCamera;
        this.backGroundCamera = backGroundCamera;
    }

    public Targetable getFocusedActor() {
        return this.focusedActor;
    }

    public void setFocusedActor(Targetable focusedTarget) {
        if (focusedTarget == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004);
        }
        this.logger.fine("Focused on: " + focusedTarget.getID() + " " + focusedTarget.getName());
        this.focusedActor = focusedTarget;
    }

    public void rumble(float strength) {
        this.rumbleFactor += MathUtils.clamp(strength, 0.0f, 10.0f);
    }

    public void startRumble(float strength) {
        this.constantRumbleStrength = MathUtils.clamp(strength, 0.0f, 10.0f);
    }

    public void endRumble() {
        this.constantRumbleStrength = 0.0f;
    }

    public void panCamera(float x, float y) {
        this.offset.add(x, y);
    }

    public void resetPanning() {
        this.offset.set(0.0f, 0.0f);
    }

    @Override
    public void zoom(float strength) {
        if (strength < 0.0f) {
            this.zoomOut(Math.abs(strength));
        } else {
            this.zoomIn(Math.abs(strength));
        }
    }

    @Override
    public void zoomIn(float strength) {
        float alpha = Interpolation.pow2.apply(0.3f * strength);
        this.targetZoom = MathUtils.clamp(this.targetZoom - alpha, 0.2f, minZoom);
    }

    @Override
    public void zoomOut(float strength) {
        float alpha = Interpolation.pow2.apply(0.3f * strength);
        this.targetZoom = MathUtils.clamp(this.targetZoom + alpha, 0.2f, maxZoom);
    }

    @Override
    public void resetZoom() {
        this.targetZoom = 1.0f;
    }

    @Override
    public float getCurrentZoom() {
        return this.targetZoom;
    }

    public void update() {
        this.backGroundCamera.zoom = this.stageCamera.zoom = this.stageCamera.zoom * 0.95f + this.targetZoom * 0.05f;
        if (this.constantRumbleStrength <= 0.0f) {
            if (this.rumbleFactor > 0.0f) {
                this.xDisplacement = (float)(Math.random() - 0.5) * 10.0f * this.rumbleFactor * this.stageCamera.zoom;
                this.yDisplacement = (float)(Math.random() - 0.5) * 10.0f * this.rumbleFactor * this.stageCamera.zoom;
                this.rumbleFactor *= 0.94f;
            }
        } else {
            this.xDisplacement = ((float)(Math.random() - 0.5) * 7.0f * this.constantRumbleStrength + (float)(Math.random() - 0.5) * this.rumbleFactor * 5.0f) * this.stageCamera.zoom;
            this.yDisplacement = ((float)(Math.random() - 0.5) * 7.0f * this.constantRumbleStrength + (float)(Math.random() - 0.5) * this.rumbleFactor * 5.0f) * this.stageCamera.zoom;
            if (this.rumbleFactor > 0.0f) {
                this.rumbleFactor *= 0.94f;
            }
        }
        this.currentFocusPos.set(((Actor)this.focusedActor.getGraphics()).getWidth() / 2.0f, ((Actor)this.focusedActor.getGraphics()).getHeight() / 2.0f);
        AstraXUtil.getWorldPosition(this.currentFocusPos, this.focusedActor.getGraphics());
        this.currentFocusPosInterpolated.set(this.currentFocusPosInterpolated.x * 0.8f + this.currentFocusPos.x * 0.2f, this.currentFocusPosInterpolated.y * 0.8f + this.currentFocusPos.y * 0.2f);
        this.offsetInterpolated.set(this.offsetInterpolated.x * 0.8f + this.offset.x * 0.2f, this.offsetInterpolated.y * 0.8f + this.offset.y * 0.2f);
        this.stageCamera.position.x = this.currentFocusPosInterpolated.x + this.offsetInterpolated.x + this.xDisplacement;
        this.stageCamera.position.y = this.currentFocusPosInterpolated.y + this.offsetInterpolated.y + this.yDisplacement;
        this.backGroundCamera.position.x = (this.currentFocusPosInterpolated.x + this.offsetInterpolated.x + this.xDisplacement) * 0.05f;
        this.backGroundCamera.position.y = (this.currentFocusPosInterpolated.y + this.offsetInterpolated.y + this.yDisplacement) * 0.05f;
    }
}

