/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.gfx.bg.Background;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import java.util.ArrayList;
import java.util.List;

public class Parallax
extends Group
implements Background {
    private float dirx;
    private float diry;
    private float speed = 2.0f;
    private boolean render = false;
    private Animation<TextureRegion> starAnimation;
    private Color[] colors;
    private List<StarLayer> starLayer = new ArrayList<StarLayer>();
    private NumberGenerator numgen;

    public Parallax(int layerAmount, TextureRegion[] regions, NumberGenerator generator) {
        if (regions.length == 0) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "Regions cannot be empty!");
        }
        for (TextureRegion region : regions) {
            if (region != null) continue;
            throw new AstraXException(AstraXException.ErrorCode.E0001, "One of the regions is null!");
        }
        this.starAnimation = new Animation<TextureRegion>(0.25f, regions);
        this.numgen = generator;
        this.init(layerAmount);
    }

    public void reinit() {
        this.init(this.starLayer.size());
    }

    private void init(int layerAmount) {
        this.render = false;
        this.starLayer.clear();
        this.colors = new Color[]{Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.valueOf("87acff"), Color.valueOf("ffc3c3"), Color.valueOf("ffc3c3"), Color.valueOf("ffeec3"), Color.valueOf("ffeec3"), Color.valueOf("ffc3f6")};
        for (int i2 = 0; i2 < layerAmount; ++i2) {
            this.starLayer.add(new StarLayer(300 / (i2 + 1), (float)(i2 + 1) * this.speed, ((float)i2 + 1.0f) / (float)layerAmount));
        }
    }

    private Animation<TextureRegion> getStarAnimation() {
        return this.starAnimation;
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        for (StarLayer starLayer : this.starLayer) {
            starLayer.init(width, height);
        }
        this.render = true;
    }

    public void setDirection(float dirx, float diry) {
        this.dirx = dirx;
        this.diry = diry;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
        int i2 = 0;
        for (StarLayer starLayer : this.starLayer) {
            starLayer.layerSpeed = (float)(i2 + 1) * this.speed;
            ++i2;
        }
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.starLayer.isEmpty()) {
            throw new AstraXException(AstraXException.ErrorCode.E0001);
        }
        for (StarLayer starLayer : this.starLayer) {
            starLayer.checkPointReset(this.speed, delta);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.starLayer.isEmpty()) {
            throw new AstraXException(AstraXException.ErrorCode.E0001);
        }
        if (this.render) {
            for (StarLayer starLayer : this.starLayer) {
                starLayer.draw(batch);
            }
            batch.setColor(Color.WHITE);
        }
    }

    private class StarLayer {
        protected StarPoint[] points;
        protected float layerSpeed;
        protected float transparency = 1.0f;

        public StarLayer(int starcount, float speed, float transparency) {
            this.points = new StarPoint[starcount];
            this.layerSpeed = speed;
            this.transparency = transparency;
        }

        public void draw(Batch batch) {
            for (StarPoint point : this.points) {
                point.draw(batch, this.transparency);
            }
        }

        public void checkPointReset(float globalSpeed, float delta) {
            for (StarPoint point : this.points) {
                point.updatePosition(delta, this.layerSpeed + globalSpeed);
                point.checkReset();
            }
        }

        public void init(float width, float height) {
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                this.points[i2] = new StarPoint(Parallax.this.numgen.getRandomFloat(width, 0.0f), Parallax.this.numgen.getRandomFloat(height, 0.0f), Parallax.this.numgen.getRandomInteger(Parallax.this.colors.length, 0));
            }
        }
    }

    private class StarPoint {
        private Vector2 pos = new Vector2();
        private int color;
        private float offset;

        public StarPoint(float posX, float posY, int color) {
            this.pos.set(posX, posY);
            this.color = color;
            this.offset = posX + posY;
        }

        public void draw(Batch batch, float transparency) {
            Color color = Parallax.this.colors[this.color];
            batch.setColor(color.r, color.g, color.b, transparency);
            int keyFrameIndex = Parallax.this.getStarAnimation().getKeyFrameIndex(MathUtils.clamp(this.offset, 0.0f, 65.0f));
            TextureRegion region = ((TextureRegion[])Parallax.this.getStarAnimation().getKeyFrames())[keyFrameIndex];
            batch.draw(region, this.pos.x, this.pos.y);
            batch.setColor(Color.WHITE);
        }

        public void checkReset() {
            if (this.pos.x > Parallax.this.getWidth()) {
                this.pos.x = 0.0f;
            }
            if (this.pos.x < 0.0f) {
                this.pos.x = Parallax.this.getWidth();
            }
            if (this.pos.y > Parallax.this.getHeight()) {
                this.pos.y = 0.0f;
            }
            if (this.pos.y < 0.0f) {
                this.pos.y = Parallax.this.getHeight();
            }
        }

        public void updatePosition(float delta, float layerSpeed) {
            this.offset = (this.offset + delta) % 80.0f;
            this.pos.set(this.pos.x - Parallax.this.dirx * layerSpeed, this.pos.y - Parallax.this.diry * layerSpeed);
        }
    }
}

