/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.PropulsionSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.Thruster;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.entities.MiningDrillGraphics;
import com.neutronio.astrax.gfx.entities.ThrusterGraphics;
import com.neutronio.astrax.util.Vector2i;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SatelliteGraphics
extends Group
implements PropulsionSystem.PropulsionSystemListener {
    private Vector2i tmp = new Vector2i();
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private AstraXRenderContext astraXRenderContext;
    private Map<Vector2i, Actor> graphicsData = new HashMap<Vector2i, Actor>();
    private Map<Vector2i, ThrusterGraphics> thrusterGraphics = new HashMap<Vector2i, ThrusterGraphics>();
    private Map<Vector2i, MiningDrillGraphics> drillGraphics = new HashMap<Vector2i, MiningDrillGraphics>();
    private boolean isPlayer = false;
    private boolean selected = false;
    private float radius = 0.0f;

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.radius = Math.max(this.getWidth() * 1.2f, this.getHeight() * 1.2f);
    }

    public boolean isPlayer() {
        return this.isPlayer;
    }

    public void setPlayer(boolean player) {
        this.isPlayer = player;
    }

    public void setAstraXRenderContext(AstraXRenderContext astraXRenderContext) {
        this.astraXRenderContext = astraXRenderContext;
    }

    public Set<Vector2i> getThrusterGraphicsKeys() {
        return this.thrusterGraphics.keySet();
    }

    public ThrusterGraphics getThrusterGraphic(Vector2i location) {
        return this.thrusterGraphics.get(location);
    }

    public Actor getGraphicsAtGridLocation(int x, int y) {
        this.tmp.set(x, y);
        return this.graphicsData.get(this.tmp);
    }

    public void addThrusterGraphics(Vector2i location, ThrusterGraphics thrusterGraphics) {
        this.graphicsData.put(location.copy(), thrusterGraphics);
        this.thrusterGraphics.put(location, thrusterGraphics);
        this.addActor(thrusterGraphics);
    }

    public void addMiningDrillGraphics(Vector2i location, MiningDrillGraphics miningDrillGraphics) {
        this.graphicsData.put(location.copy(), miningDrillGraphics);
        this.drillGraphics.put(location, miningDrillGraphics);
        this.addActor(miningDrillGraphics);
    }

    public void startMiningDrills() {
        for (MiningDrillGraphics miningDrillGraphics : this.drillGraphics.values()) {
            miningDrillGraphics.start();
        }
    }

    public void startMiningDrill(Vector2i location) {
        if (this.drillGraphics.containsKey(location)) {
            this.drillGraphics.get(location).start();
        }
    }

    public void stopMiningDrills() {
        for (MiningDrillGraphics miningDrillGraphics : this.drillGraphics.values()) {
            miningDrillGraphics.stop();
        }
    }

    public void stopMiningDrill(Vector2i location) {
        if (this.drillGraphics.containsKey(location)) {
            this.drillGraphics.get(location).stop();
        }
    }

    public void updateThrusterGraphics(Vector2i location, Thruster thruster) {
        if (this.thrusterGraphics.containsKey(location)) {
            ThrusterGraphics thrusterGraphics = this.thrusterGraphics.get(location);
            thrusterGraphics.updateNozzle(thruster.getThrusterPowerFactor());
        }
    }

    public void addTexture(TextureRegion region, Color tint, float x, float y, int gridX, int gridY, float rotation, float scale) {
        if (region == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Region is null");
        }
        Image sprite = new Image(region);
        sprite.setOrigin(sprite.getWidth() / 2.0f, sprite.getHeight() / 2.0f);
        sprite.setColor(tint);
        sprite.setRotation(rotation);
        sprite.setScale(scale);
        sprite.setPosition(x, y, 1);
        this.tmp.set(gridX, gridY);
        this.graphicsData.put(this.tmp.copy(), sprite);
        this.addActor(sprite);
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    public void updateSound(Satellite satellite) {
        float dampening = Math.max(0.2f, 1.0f / (float)this.thrusterGraphics.size());
        for (Map.Entry<Vector2i, ThrusterGraphics> thrusterEntry : this.thrusterGraphics.entrySet()) {
            ThrusterGraphics thrusterGraphics = thrusterEntry.getValue();
            Thruster thruster = satellite.getThruster(thrusterEntry.getKey());
            thrusterGraphics.updateSound(thruster, dampening);
        }
    }

    @Override
    protected void drawChildren(Batch batch, float parentAlpha) {
        super.drawChildren(batch, parentAlpha);
        if (this.selected && !this.isPlayer) {
            float x = this.getWidth() / 2.0f - this.radius / 2.0f;
            float y = this.getHeight() / 2.0f - this.radius / 2.0f;
            this.astraXRenderContext.getShapeDrawer().filledCircle(128.0f, 128.0f, 12.0f, Color.YELLOW);
            this.astraXRenderContext.getShapeTargetor().render(this.astraXRenderContext.getShapeDrawer(), x, y, this.radius, this.radius, Gdx.graphics.getDeltaTime());
        }
    }

    @Override
    public void onThrusterGroupStarted(Satellite parent, List<Thruster> thrusters) {
        for (Thruster thruster : thrusters) {
            this.logger.finest("Start thruster @" + thruster.getLocation());
            ThrusterGraphics thrusterGraphic = this.getThrusterGraphic(thruster.getLocation());
            thrusterGraphic.onStart();
        }
        this.logger.finest("--");
    }

    @Override
    public void onThrusterGroupStopped(Satellite parent, List<Thruster> thrusters) {
        for (Thruster thruster : thrusters) {
            this.logger.finest("Stop thruster @" + thruster.getLocation());
            ThrusterGraphics thrusterGraphic = this.getThrusterGraphic(thruster.getLocation());
            thrusterGraphic.onStop();
        }
        this.logger.finest("--");
    }

    public void dispose() {
        for (Map.Entry<Vector2i, ThrusterGraphics> thrusterEntry : this.thrusterGraphics.entrySet()) {
            ThrusterGraphics thrusterGraphics = thrusterEntry.getValue();
            thrusterGraphics.onStop();
        }
    }
}

