/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.gfx.AnimationGraphics;
import com.neutronio.astrax.gfx.AnimationStateGraphics;
import com.neutronio.astrax.util.collections.Grid;
import java.util.List;

public class SatelliteGraphicsGrid {
    private static final int TEXTURE_REGION = 0;
    private static final int ANIMATION = 1;
    private static final int ANIMATION_STATE = 2;
    List<Module> modules;
    Grid<Cell> data;

    public static class Cell {
        int x = 0;
        int y = 0;
        int mode = 0;
        Object graphics;

        public Cell(TextureRegion staticGraphics) {
            this.graphics = staticGraphics;
            this.mode = 0;
        }

        public Cell(AnimationGraphics animationGraphics) {
            this.graphics = animationGraphics;
            this.mode = 1;
        }

        public Cell(AnimationStateGraphics animationStateGraphics) {
            this.graphics = animationStateGraphics;
            this.mode = 2;
        }

        public void render(float time, Batch batch) {
            switch (this.mode) {
                case 0: {
                    batch.draw((TextureRegion)this.graphics, (float)(this.x * 16), (float)(this.y * 16));
                }
                case 1: {
                    ((AnimationGraphics)this.graphics).update(time);
                    batch.draw(((AnimationGraphics)this.graphics).getCurrentFrame(), (float)(this.x * 16), (float)(this.y * 16));
                }
                case 2: {
                    ((AnimationStateGraphics)this.graphics).update(time);
                    batch.draw(((AnimationStateGraphics)this.graphics).getCurrentFrame(), (float)(this.x * 16), (float)(this.y * 16));
                }
            }
        }
    }
}

