/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.gfx.bg.Background;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScrollStage {
    private static Logger logger = Logger.getLogger(ScrollStage.class.getCanonicalName());
    float scrollAmountX = 0.05f;
    float scrollAmountY = 0.05f;
    protected Stage stage = new Stage();

    public void addToStage(Actor actor) {
        if (!(actor instanceof Background)) {
            throw new AstraXException(AstraXException.ErrorCode.E0003, "Actor must implement background!");
        }
        this.stage.addActor(actor);
    }

    public void addToStageWithTransform(Actor actor) {
        if (!(actor instanceof Background)) {
            throw new AstraXException(AstraXException.ErrorCode.E0003, "Actor must implement background!");
        }
        logger.log(Level.FINE, "Added actor " + actor.getClass() + " to global coordinates " + actor.getX() + " " + actor.getY());
        actor.setPosition(actor.getX() * (this.scrollAmountX / 1.0f), actor.getY() * (this.scrollAmountY / 1.0f));
        logger.log(Level.FINE, "ScrollStage coordinates: " + actor.getX() + " " + actor.getY());
        this.stage.addActor(actor);
    }

    public Vector2 toLocalCoordinates(float globalX, float globalY) {
        return new Vector2(globalX * (this.scrollAmountX / 1.0f), globalY * (this.scrollAmountY / 1.0f));
    }

    public void render(float playerPositionX, float playerPositionY) {
        this.stage.getCamera().position.x = playerPositionX * this.scrollAmountX;
        this.stage.getCamera().position.y = playerPositionY * this.scrollAmountY;
        this.stage.act();
        this.stage.draw();
    }

    public Stage getStage() {
        return this.stage;
    }

    public Camera getCamera() {
        return this.stage.getCamera();
    }
}

