/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.neutronio.astrax.gfx.particles.AnimatedParticleEmitter;
import com.neutronio.astrax.sfx.SpatialSoundManager;
import com.neutronio.astrax.util.AstraXUtil;

public class MiningDrillGraphics
extends Group {
    protected float time = (float)Math.random();
    protected float rpm = 0.0f;
    protected boolean running = false;
    private Vector2 worldPos = new Vector2();
    private Animation<TextureRegion> drillAnimation;
    private TextureRegionDrawable currentDrillDrawable = new TextureRegionDrawable();
    private Image drillImage = new Image();
    private AnimatedParticleEmitter sparkEmitter;
    private AnimatedParticleEmitter smokeEmitterLeft;
    private AnimatedParticleEmitter smokeEmitterRight;
    private SpatialSoundManager.LoopedSpatialSound drillSound;

    public MiningDrillGraphics() {
        this.drillImage.setDrawable(this.currentDrillDrawable);
        this.drillImage.setSize(16.0f, 16.0f);
        this.drillImage.setOrigin(1);
        this.addActor(this.drillImage);
        this.setSize(16.0f, 16.0f);
        this.setOrigin(1);
    }

    public MiningDrillGraphics copy() {
        MiningDrillGraphics copy = new MiningDrillGraphics();
        copy.setDrillAnimation(this.drillAnimation);
        copy.setSparkEmitter(this.sparkEmitter.copy());
        copy.setSmokeEmitterLeft(this.smokeEmitterLeft.copy());
        copy.setSmokeEmitterRight(this.smokeEmitterRight.copy());
        copy.setSparkEmitter(this.sparkEmitter.copy());
        copy.rpm = this.rpm;
        copy.running = this.running;
        return copy;
    }

    public void setDrillSound(SpatialSoundManager.LoopedSpatialSound drillSound) {
        this.drillSound = drillSound;
    }

    public void setDrillAnimation(Animation<TextureRegion> drillAnimation) {
        this.drillAnimation = drillAnimation;
    }

    public void setSparkEmitter(AnimatedParticleEmitter sparkEmitter) {
        if (this.sparkEmitter != null) {
            this.sparkEmitter.remove();
        }
        this.sparkEmitter = sparkEmitter;
        this.sparkEmitter.setPosition(16.0f, 8.0f);
        this.addActor(this.sparkEmitter);
    }

    public void setSmokeEmitterLeft(AnimatedParticleEmitter smokeEmitter) {
        if (this.smokeEmitterLeft != null) {
            this.smokeEmitterLeft.remove();
        }
        this.smokeEmitterLeft = smokeEmitter;
        this.smokeEmitterLeft.setPosition(16.0f, 8.0f);
        this.addActor(this.smokeEmitterLeft);
    }

    public void setSmokeEmitterRight(AnimatedParticleEmitter smokeEmitter) {
        if (this.smokeEmitterRight != null) {
            this.smokeEmitterRight.remove();
        }
        this.smokeEmitterRight = smokeEmitter;
        this.smokeEmitterRight.setPosition(16.0f, 8.0f);
        this.addActor(this.smokeEmitterRight);
    }

    public void start() {
        this.running = true;
        this.sparkEmitter.start();
        this.smokeEmitterLeft.start();
        this.smokeEmitterRight.start();
        if (this.drillSound != null) {
            this.drillSound.loop();
        }
    }

    public void stop() {
        this.running = false;
        this.sparkEmitter.stop();
        this.smokeEmitterLeft.stop();
        this.smokeEmitterRight.stop();
        if (this.drillSound != null) {
            this.drillSound.stop();
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.time += Gdx.graphics.getDeltaTime() * this.rpm;
        if (this.running) {
            if (this.rpm <= 1.0f) {
                this.rpm += 0.1f;
            }
        } else {
            this.rpm *= 0.98f;
        }
        this.worldPos.set(0.0f, 0.0f);
        AstraXUtil.getWorldPosition(this.worldPos, this);
        if (this.drillSound != null) {
            this.drillSound.setPitch(this.rpm);
            this.drillSound.update(Gdx.graphics.getDeltaTime(), this.worldPos.x, this.worldPos.y);
        }
        this.currentDrillDrawable.setRegion(this.drillAnimation.getKeyFrame(this.time));
        super.draw(batch, parentAlpha);
    }
}

