/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.neutronio.astrax.app.datapack.game.world.OrbitRing;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetCreationSettings;
import com.neutronio.astrax.gfx.AnimationGraphics;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.entities.AnimatedPlanetImage;
import com.neutronio.astrax.gfx.entities.StaticPlanetImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class PlanetGraphics
extends Group {
    Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private int planetWidth = 0;
    private int planetHeight = 0;
    private float discoveredFactor = 0.0f;
    private boolean selected = false;
    public List<StaticPlanetImage> planetTextures = new ArrayList<StaticPlanetImage>();
    private StaticPlanetImage shadowMask;
    private PlanetCreationSettings settings;
    private AstraXRenderContext astraXRenderContext;
    private List<OrbitRing> orbitRings = new ArrayList<OrbitRing>();

    public PlanetGraphics() {
        this.setOrigin(1);
    }

    public void addOrbitRing(OrbitRing orbitRing) {
        this.orbitRings.add(orbitRing);
    }

    public void setAstraXRenderContext(AstraXRenderContext astraXRenderContext) {
        this.astraXRenderContext = astraXRenderContext;
    }

    @Override
    public void addActor(Actor actor) {
        if (!this.equals(actor)) {
            super.addActor(actor);
        } else {
            this.logger.warning("Trying to add actor to itself! Affected actor: " + this.settings.getName());
        }
    }

    public PlanetCreationSettings getSettings() {
        return this.settings;
    }

    public void setSettings(PlanetCreationSettings settings) {
        this.settings = settings;
    }

    public void setDiscoveredFactor(float discoveredFactor) {
        this.discoveredFactor = discoveredFactor;
    }

    public boolean hasShadowMask() {
        return this.settings.useShadowMask;
    }

    public void setShadowMask(TextureAtlas.AtlasRegion region, Color color, int layer) {
        if (this.shadowMask != null) {
            return;
        }
        StaticPlanetImage staticPlanetImage = new StaticPlanetImage(region, color, 0.0f, layer);
        staticPlanetImage.getImage().setSize(this.planetWidth, this.planetHeight);
        staticPlanetImage.getImage().setOrigin(staticPlanetImage.getImage().getWidth() / 2.0f, staticPlanetImage.getImage().getHeight() / 2.0f);
        this.shadowMask = staticPlanetImage;
    }

    public void addStaticImage(TextureAtlas.AtlasRegion region, Color color, float rotation, int layer) {
        StaticPlanetImage staticPlanetImage = new StaticPlanetImage(region, color, rotation, layer);
        staticPlanetImage.getImage().setSize(this.planetWidth, this.planetHeight);
        staticPlanetImage.getImage().setOrigin(staticPlanetImage.getImage().getWidth() / 2.0f, staticPlanetImage.getImage().getHeight() / 2.0f);
        this.planetTextures.add(staticPlanetImage);
    }

    public void addAnimatedImage(AnimationGraphics animationGraphics, Color color, float rotationSpeed, int layer) {
        AnimatedPlanetImage animatedPlanetImage = new AnimatedPlanetImage(animationGraphics, color, rotationSpeed, layer);
        this.planetTextures.add(animatedPlanetImage);
    }

    public List<StaticPlanetImage> getPlanetTextures() {
        return this.planetTextures;
    }

    public void setPlanetSize(int width, int height) {
        this.planetWidth = width;
        this.planetHeight = height;
    }

    public int getPlanetWidth() {
        return this.planetWidth;
    }

    public int getPlanetHeight() {
        return this.planetHeight;
    }

    public void sortPlanetTextures() {
        Collections.sort(this.planetTextures);
    }

    public void faceTo(float rotation) {
        this.shadowMask.getImage().setRotation(rotation);
    }

    public void updateSize() {
        for (StaticPlanetImage staticPlanetImage : this.planetTextures) {
            staticPlanetImage.getImage().setSize(this.planetWidth, this.planetHeight);
            staticPlanetImage.getImage().setOrigin(staticPlanetImage.getImage().getWidth() / 2.0f, staticPlanetImage.getImage().getHeight() / 2.0f);
        }
        if (this.shadowMask != null) {
            this.shadowMask.getImage().setSize(this.planetWidth, this.planetHeight);
            this.shadowMask.getImage().setOrigin(this.shadowMask.getImage().getWidth() / 2.0f, this.shadowMask.getImage().getHeight() / 2.0f);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        for (StaticPlanetImage staticPlanetImage : this.planetTextures) {
            staticPlanetImage.update(Gdx.graphics.getDeltaTime());
            staticPlanetImage.getImage().setRotation(staticPlanetImage.rotation);
            staticPlanetImage.getImage().setPosition(this.getX() - (float)(this.planetWidth / 2) + this.getWidth() / 2.0f, this.getY() - (float)(this.planetHeight / 2) + this.getHeight() / 2.0f);
            staticPlanetImage.getImage().draw(batch, parentAlpha);
        }
        if (this.shadowMask != null) {
            this.shadowMask.update(Gdx.graphics.getDeltaTime());
            this.shadowMask.getImage().setPosition(this.getX() - (float)(this.planetWidth / 2) + this.getWidth() / 2.0f, this.getY() - (float)(this.planetHeight / 2) + this.getHeight() / 2.0f);
            this.shadowMask.getImage().draw(batch, parentAlpha);
        }
        super.draw(batch, parentAlpha);
    }

    @Override
    protected void drawChildren(Batch batch, float parentAlpha) {
        super.drawChildren(batch, parentAlpha);
        if (!this.orbitRings.isEmpty()) {
            for (OrbitRing ring : this.orbitRings) {
                float x1 = (float)(-ring.width) / 2.0f + this.getWidth() / 2.0f;
                float y1 = (float)(-ring.height) / 2.0f + this.getHeight() / 2.0f;
                ring.render(this.astraXRenderContext.getShapeDrawer(), x1, y1, 1.0f, 1.0f, Gdx.graphics.getDeltaTime());
            }
        }
        if (this.selected) {
            float x = (float)(-(this.planetWidth + 30)) / 2.0f + this.getWidth() / 2.0f;
            float y = (float)(-(this.planetHeight + 30)) / 2.0f + this.getHeight() / 2.0f;
            float width = this.planetWidth + 30;
            float height = (float)this.planetHeight + 30.0f;
            this.astraXRenderContext.getShapeTargetor().render(this.astraXRenderContext.getShapeDrawer(), x, y, width, height, Gdx.graphics.getDeltaTime());
            this.astraXRenderContext.getCircleBarRenderer().render(this.astraXRenderContext.getShapeDrawer(), Color.BLUE, x, y, width, height, (float)Math.PI, this.discoveredFactor);
        }
    }

    public void toggleSelect() {
        this.selected = !this.selected;
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    @Override
    public float getScaleX() {
        return 1.0f;
    }

    @Override
    public float getScaleY() {
        return 1.0f;
    }

    public PlanetGraphics copy() {
        PlanetGraphics copy = new PlanetGraphics();
        if (this.shadowMask != null) {
            copy.shadowMask = this.shadowMask.copy();
        }
        copy.planetWidth = this.planetWidth;
        copy.planetHeight = this.planetHeight;
        copy.settings = this.settings;
        copy.astraXRenderContext = this.astraXRenderContext;
        for (StaticPlanetImage image : this.planetTextures) {
            StaticPlanetImage staticImageCopy = image.copy();
            copy.planetTextures.add(staticImageCopy);
            copy.planetTextures.add(staticImageCopy);
        }
        return copy;
    }
}

