/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.Thruster;
import com.neutronio.astrax.gfx.AnimationStateGraphics;
import com.neutronio.astrax.gfx.particles.AnimatedParticleEmitter;
import com.neutronio.astrax.sfx.SpatialSoundManager;
import com.neutronio.astrax.util.AstraXUtil;

public class ThrusterGraphics
extends Group {
    protected float time = (float)Math.random();
    private Vector2 worldPos = new Vector2();
    private Vector2 nozzleOffset;
    private Image currentNozzleFrame;
    private TextureRegionDrawable currentNozzleDrawable = null;
    private AnimationStateGraphics nozzleAnimation;
    private AnimatedParticleEmitter trailEmitter;
    private SpatialSoundManager.LoopedSpatialSound engineSound;
    private SpatialSoundManager.LoopedSpatialSound startSound;

    public ThrusterGraphics(AnimationStateGraphics nozzleAnimation, AnimatedParticleEmitter trailEmitter) {
        this.nozzleAnimation = nozzleAnimation;
        this.trailEmitter = trailEmitter;
        this.currentNozzleDrawable = new TextureRegionDrawable(nozzleAnimation.getCurrentFrame());
        this.currentNozzleFrame = new Image();
        this.currentNozzleFrame.setSize(nozzleAnimation.getCurrentFrame().getRegionWidth(), nozzleAnimation.getCurrentFrame().getRegionHeight());
        this.currentNozzleFrame.setDrawable(this.currentNozzleDrawable);
        this.currentNozzleFrame.setOrigin(1);
        this.addActor(this.trailEmitter);
        this.addActor(this.currentNozzleFrame);
        this.setSize(16.0f, 16.0f);
        this.setOrigin(1);
    }

    public ThrusterGraphics copy() {
        AnimatedParticleEmitter trailAnimation = new AnimatedParticleEmitter();
        trailAnimation.setAnimation(this.trailEmitter.getAnimation());
        AnimationStateGraphics nozzleAnimation = this.nozzleAnimation.copy();
        ThrusterGraphics copy = new ThrusterGraphics(nozzleAnimation, trailAnimation);
        copy.configureNozzle(this.getRotation());
        return copy;
    }

    public void setEngineSound(SpatialSoundManager.LoopedSpatialSound engineSound) {
        this.engineSound = engineSound;
    }

    public void setStartSound(SpatialSoundManager.LoopedSpatialSound startSound) {
        this.startSound = startSound;
    }

    public void configureNozzle(float rotation) {
        this.currentNozzleFrame.setPosition(-this.currentNozzleFrame.getWidth(), 2.0f);
        this.trailEmitter.setPosition(-this.currentNozzleFrame.getWidth() / 3.0f, this.currentNozzleFrame.getHeight() / 2.0f);
        this.setRotation(rotation);
    }

    public void updateSound(Thruster thruster, float volumeDampening) {
        this.engineSound.setPitch(Interpolation.pow2.apply(0.5f, 1.2f, thruster.getThrusterPowerFactor()));
        this.engineSound.setVolumeMultiplier(Interpolation.pow2.apply(0.2f * volumeDampening, 0.6f * volumeDampening, thruster.getThrusterPowerFactor()));
    }

    public void playStartSound() {
        this.startSound.play();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.time += Gdx.graphics.getDeltaTime();
        this.worldPos.set(0.0f, 0.0f);
        AstraXUtil.getWorldPosition(this.worldPos, this);
        if (this.engineSound != null && this.startSound != null) {
            this.engineSound.update(Gdx.graphics.getDeltaTime(), this.worldPos.x, this.worldPos.y);
            this.startSound.update(Gdx.graphics.getDeltaTime(), this.worldPos.x, this.worldPos.y);
        }
        this.nozzleAnimation.update(this.time);
        this.currentNozzleDrawable.setRegion(this.nozzleAnimation.getCurrentFrame());
        super.draw(batch, parentAlpha);
    }

    public void onStop() {
        this.trailEmitter.stop();
        if (this.engineSound != null) {
            this.engineSound.stop();
        }
    }

    public void onStart() {
        this.trailEmitter.start();
        if (this.startSound != null) {
            // empty if block
        }
        if (this.engineSound != null) {
            this.engineSound.setPitch(0.5f);
            this.engineSound.setVolumeMultiplier(0.0f);
            this.engineSound.loop();
        }
    }

    public void updateNozzle(float thrusterFactor) {
        this.nozzleAnimation.setCurrentState(thrusterFactor * 100.0f);
        if (thrusterFactor < 0.1f) {
            thrusterFactor = 0.0f;
        }
        this.trailEmitter.setEmissionRate(Interpolation.pow2.apply(0.0f, this.trailEmitter.getMaxEmissionRate(), thrusterFactor));
        this.trailEmitter.getLife().set(Float.valueOf(Math.max(thrusterFactor * 0.6f, 0.4f)), Float.valueOf(Math.max(thrusterFactor * 0.4f, 0.3f)));
    }
}

