/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.factories;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.DressupLayer;
import com.neutronio.astrax.app.DressupSettings;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.repository.DressupSettingsRepository;
import com.neutronio.astrax.ui.AstraXSkin;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AvatarFactory
extends AbstractFactory {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private AstraXSkin skin;
    private DressupSettingsRepository repository;

    public AvatarFactory() {
        this.repository = AstraXApp.astraX.getRepository(DressupSettingsRepository.class);
    }

    public AvatarFactory(DataContext dataContext) {
        super(dataContext);
        this.repository = dataContext.getRepository(DressupSettingsRepository.class);
    }

    public AstraXSkin getSkin() {
        return this.skin;
    }

    public void setSkin(AstraXSkin skin) {
        this.skin = skin;
    }

    public List<Image> create(Integer[] textures, Integer[] colors, String settingsID) {
        DressupSettings avatarSettings = (DressupSettings)this.repository.find(settingsID);
        return this.create(textures, colors, avatarSettings);
    }

    public List<Image> create(Integer[] textures, Integer[] colors, DressupSettings settings) {
        if (textures.length != colors.length) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "textures.length != colors.length");
        }
        if (textures.length != settings.layers.size()) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "textures.length != settings.layers.size()");
        }
        ArrayList<Image> images = new ArrayList<Image>();
        for (int i2 = 0; i2 < textures.length; ++i2) {
            if (colors[i2] == null || textures[i2] == null) continue;
            DressupLayer layer = settings.layers.get(i2);
            Color color = layer.availableColors.get(colors[i2]);
            DressupLayer.TextureSettings textureSettings = layer.definitions.get(textures[i2]);
            Array<TextureAtlas.AtlasRegion> regions = this.skin.getAtlas().findRegions(layer.baseTextureRegion);
            this.logger.log(Level.FINE, "Color: {0} {1}, Texture: {2} {3}", new Object[]{colors[i2], color, textures[i2], textureSettings.displayName});
            Image image = new Image(regions.get(textures[i2]));
            image.setColor(color);
            image.setPosition(textureSettings.positionX, textureSettings.positionY);
            image.setRotation(textureSettings.rotation);
            images.add(image);
        }
        return images;
    }
}

