/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.factories;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitalBeltSettings;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.app.repository.ColorRepository;
import com.neutronio.astrax.gfx.OrbitalBeltGraphics;
import com.neutronio.astrax.util.MathUtil;
import java.util.List;
import java.util.Map;

public class OrbitalBeltGraphicsFactory
extends AbstractFactory
implements GenericFactory<OrbitalBeltGraphics, OrbitalBeltSettings> {
    protected ColorRepository colorRepository;
    protected Map<String, Color> planetPalette;

    public OrbitalBeltGraphicsFactory() {
    }

    public OrbitalBeltGraphicsFactory(DataContext dataContext) {
        super(dataContext);
        this.colorRepository = dataContext.getRepository(ColorRepository.class);
        this.planetPalette = (Map)this.colorRepository.find("palette-planet");
    }

    @Override
    public OrbitalBeltGraphics create(OrbitalBeltSettings settings) {
        OrbitalBeltGraphics orbitalBeltGraphics = new OrbitalBeltGraphics();
        List<String> chunkNames = settings.getChunkNames();
        int chunkCount = (int)MathUtil.getAsteroidCountByDensity(settings.getChunkDensity(), settings.getOrbitMaxRadius(), settings.getOrbitMinRadius());
        this.logger.info("Adding randomized chunks, count: " + chunkCount);
        for (int i2 = 0; i2 < chunkCount; ++i2) {
            Vector2 randomPosition = this.getRandomPointInDisc(settings.getOrbitMaxRadius(), settings.getOrbitMinRadius());
            String randomChunkName = this.numberGenerator.getRandomEntry(chunkNames);
            String randomColorName = this.numberGenerator.getRandomEntry(settings.getColors());
            Array<TextureAtlas.AtlasRegion> regions = this.dataPack.getTextureAtlas().findRegions(randomChunkName);
            TextureAtlas.AtlasRegion randomAsteroidParticle = this.numberGenerator.getRandomEntry(regions);
            orbitalBeltGraphics.addParticle(randomAsteroidParticle, this.planetPalette.get(randomColorName), randomPosition.x, randomPosition.y, this.numberGenerator.getRandomFloat(360.0f, 0.0f));
        }
        return orbitalBeltGraphics;
    }

    private Vector2 getRandomPointInDisc(float maxradius, float minradius) {
        float randomWidth = this.numberGenerator.getRandomFloat(maxradius, minradius);
        float randomTime = this.numberGenerator.getRandomFloat(360.0f, 0.0f);
        float x = (float)((double)randomWidth * Math.cos(randomTime));
        float y = (float)((double)randomWidth * Math.sin(randomTime));
        return new Vector2(x, y);
    }
}

