/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.factories;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.gfx.AnimatedParticleEmitterSettings;
import com.neutronio.astrax.gfx.particles.AnimatedParticleEmitter;

public class ParticleFactory
extends AbstractFactory
implements GenericFactory<AnimatedParticleEmitter, AnimatedParticleEmitterSettings> {
    public ParticleFactory() {
    }

    public ParticleFactory(DataContext dataContext) {
        super(dataContext);
    }

    @Override
    public AnimatedParticleEmitter create(AnimatedParticleEmitterSettings emitterSettings) {
        Array<TextureAtlas.AtlasRegion> regions = this.dataPack.getTextureAtlas().findRegions(emitterSettings.regionName);
        Animation<TextureAtlas.AtlasRegion> animation = new Animation<TextureAtlas.AtlasRegion>(0.1f, regions.toArray());
        animation.setPlayMode(Animation.PlayMode.NORMAL);
        AnimatedParticleEmitter particleEmitter = new AnimatedParticleEmitter();
        particleEmitter.setParticleAmount(emitterSettings.particleAmount);
        particleEmitter.setAnimation(animation);
        particleEmitter.setMaxEmissionRate(emitterSettings.defaultEmissionRate);
        particleEmitter.setEmissionRate(emitterSettings.defaultEmissionRate);
        particleEmitter.getAngularVelocity().set(Float.valueOf(emitterSettings.angularVelocityMax), Float.valueOf(emitterSettings.angularVelocityMin));
        particleEmitter.setContinuous(emitterSettings.continuous);
        particleEmitter.getLife().set(Float.valueOf(emitterSettings.lifeMax), Float.valueOf(emitterSettings.lifeMin));
        particleEmitter.getVelocity().set(Float.valueOf(emitterSettings.velocityMax), Float.valueOf(emitterSettings.velocityMin));
        particleEmitter.getSpread().set(Float.valueOf(emitterSettings.spreadMax), Float.valueOf(emitterSettings.spreadMin));
        particleEmitter.getDelay().set(Float.valueOf(emitterSettings.delayMax), Float.valueOf(emitterSettings.delayMin));
        particleEmitter.getDirection().set(Float.valueOf(emitterSettings.directionMax), Float.valueOf(emitterSettings.directionMin));
        particleEmitter.populateWithParticles();
        particleEmitter.setSettings(emitterSettings);
        return particleEmitter;
    }
}

