/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.factories;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.world.OrbitRing;
import com.neutronio.astrax.app.datapack.game.world.OrbitRingSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.TextureCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.TextureGenerationSetting;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetCreationSettings;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.Generator;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;
import java.util.logging.Level;

public class PlanetGraphicsFactory
extends AbstractFactory
implements GenericFactory<PlanetGraphics, PlanetCreationSettings>,
Generator<TextureCreationSettings, TextureGenerationSetting> {
    public static int defaultTextureSize = 256;
    private AstraXRenderContext worldRenderContext;

    public PlanetGraphicsFactory() {
    }

    public PlanetGraphicsFactory(DataContext dataContext) {
        super(dataContext);
    }

    public void setWorldRenderContext(AstraXRenderContext worldRenderContext) {
        this.worldRenderContext = worldRenderContext;
    }

    @Override
    public PlanetGraphics create(PlanetCreationSettings settings) {
        this.logger.log(Level.INFO, "Assembling Planet of ID \"{0}\" using settings \"{1}\"...", new Object[]{settings.name + "", settings.name + ""});
        if (this.worldRenderContext == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "AstraXRenderContext that uses a World Stage must be set!");
        }
        if (settings.scale.floatValue() <= 0.0f) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Scale cannot be <= 0");
        }
        PlanetGraphics planet = new PlanetGraphics();
        planet.setSettings(settings);
        planet.setAstraXRenderContext(this.worldRenderContext);
        int diameter = (int)(settings.scale.floatValue() * (float)defaultTextureSize);
        planet.setPlanetSize(diameter, diameter);
        planet.setSize(defaultTextureSize, defaultTextureSize);
        this.logger.log(Level.FINE, "... Scale: {0}", settings.scale);
        for (TextureCreationSettings texture : settings.textureSettings) {
            this.addTexture(planet, texture);
        }
        if (settings.orbitRingSettings != null) {
            for (OrbitRingSettings orbitRingSettings : settings.orbitRingSettings) {
                this.logger.log(Level.FINE, "... Adding ring");
                planet.addOrbitRing(new OrbitRing((int)(orbitRingSettings.distanceFactor * (float)planet.getPlanetWidth()), (int)(orbitRingSettings.distanceFactor * (float)planet.getPlanetHeight()), orbitRingSettings.thickness, this.numberGenerator.getRandomEntry(orbitRingSettings.colors), this.numberGenerator.getRandomInteger(20, 5)));
            }
        }
        if (settings.useShadowMask) {
            planet.setShadowMask(this.dataPack.getTextureAtlas().findRegion("env/planet_shadow"), Color.BLACK, 99);
        }
        planet.sortPlanetTextures();
        return planet;
    }

    private void addTexture(PlanetGraphics target, TextureCreationSettings settings) {
        TextureAtlas.AtlasRegion region = null;
        this.logger.log(Level.FINEST, "Assembling texture {0} {1}", new Object[]{settings.texture, settings.textureIndex});
        region = settings.textureIndex > 0 ? this.dataPack.getTextureAtlas().findRegion(settings.texture, settings.textureIndex) : this.dataPack.getTextureAtlas().findRegion(settings.texture);
        if (region == null) {
            this.logger.log(Level.WARNING, "Could not find texture region of name {0} and index {1}, creation of texture skipped", new Object[]{settings.texture, settings.textureIndex});
            return;
        }
        if (settings.color == null) {
            this.logger.log(Level.WARNING, "Could not find color for texture {0}", new Object[]{settings.texture});
            return;
        }
        Color color = settings.color.cpy();
        color.a = settings.alphaOverride;
        target.addStaticImage(region, color, settings.rotation, settings.layer);
    }

    @Override
    public TextureCreationSettings generate(TextureGenerationSetting generationSetting) {
        TextureCreationSettings creationSettings = new TextureCreationSettings();
        creationSettings.layer = generationSetting.layer;
        creationSettings.color = this.numberGenerator.getRandomEntry(generationSetting.color);
        creationSettings.rotation = this.numberGenerator.getRandomFloat(generationSetting.maxRotation, generationSetting.minRotation);
        creationSettings.alphaOverride = generationSetting.alphaOverride;
        Array<TextureAtlas.AtlasRegion> regions = this.dataPack.getTextureAtlas().findRegions(generationSetting.texture);
        if (regions.isEmpty()) {
            throw new AstraXException(AstraXException.ErrorCode.E3110, generationSetting.texture);
        }
        TextureAtlas.AtlasRegion atlasRegion = this.numberGenerator.getRandomEntry(regions);
        creationSettings.texture = atlasRegion.name;
        creationSettings.textureIndex = atlasRegion.index;
        return creationSettings;
    }
}

