/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.factories;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.app.repository.AnimatedParticleEmitterRepository;
import com.neutronio.astrax.gfx.AnimatedParticleEmitterSettings;
import com.neutronio.astrax.gfx.AnimationStateGraphics;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.gfx.entities.MiningDrillGraphics;
import com.neutronio.astrax.gfx.entities.ThrusterGraphics;
import com.neutronio.astrax.gfx.factories.ParticleFactory;
import com.neutronio.astrax.gfx.particles.AnimatedParticleEmitter;
import com.neutronio.astrax.util.Vector2i;
import java.util.logging.Level;

public class SatelliteGraphicsFactory
extends AbstractFactory
implements GenericFactory<SatelliteGraphics, Object> {
    private AstraXRenderContext worldRenderContext;
    protected AnimatedParticleEmitterRepository particleEmitterRepository;
    protected ParticleFactory particleFactory;

    public SatelliteGraphicsFactory() {
    }

    public SatelliteGraphicsFactory(DataContext dataContext) {
        super(dataContext);
        this.particleEmitterRepository = dataContext.getRepository(AnimatedParticleEmitterRepository.class);
        this.particleFactory = dataContext.getFactory(ParticleFactory.class);
    }

    public void setWorldRenderContext(AstraXRenderContext worldRenderContext) {
        this.worldRenderContext = worldRenderContext;
    }

    public SatelliteGraphics createGraphics(SatelliteGrid satelliteGrid) {
        this.logger.log(Level.FINE, "Assembling Satellite...");
        SatelliteGraphics satelliteGraphics = new SatelliteGraphics();
        Animation<TextureAtlas.AtlasRegion> fullThrottle = this.createExhaustAnimation((TextureAtlas.AtlasRegion[])this.dataPack.getTextureAtlas().findRegions((String)"env/engine100").items);
        Animation<TextureAtlas.AtlasRegion> midThrottle = this.createExhaustAnimation((TextureAtlas.AtlasRegion[])this.dataPack.getTextureAtlas().findRegions((String)"env/engine60").items);
        Animation<TextureAtlas.AtlasRegion> lowThrottle = this.createExhaustAnimation((TextureAtlas.AtlasRegion[])this.dataPack.getTextureAtlas().findRegions((String)"env/engine30").items);
        Rectangle rectangle = satelliteGrid.getDimension();
        satelliteGraphics.setSize(rectangle.width * 16.0f, rectangle.height * 16.0f);
        this.logger.log(Level.FINE, "Dimensions: " + rectangle.toString());
        for (int x = 0; x < satelliteGrid.getData().getWidth() + 1; ++x) {
            for (int y = 0; y < satelliteGrid.getData().getHeight() + 1; ++y) {
                float posX = (float)(x * 16) - rectangle.x * 16.0f + 8.0f;
                float posY = (float)(y * 16) - rectangle.y * 16.0f + 8.0f;
                SatelliteGrid.SatelliteGridSettings settings = satelliteGrid.getData().get(x, y);
                if (settings == null) continue;
                if (settings.moduleSettings.drillSettings != null) {
                    AnimatedParticleEmitter particleEmitterSmokeLeft = this.particleFactory.create((AnimatedParticleEmitterSettings)this.particleEmitterRepository.find("fx_drill_left"));
                    AnimatedParticleEmitter particleEmitterSmokeRight = this.particleFactory.create((AnimatedParticleEmitterSettings)this.particleEmitterRepository.find("fx_drill_right"));
                    AnimatedParticleEmitter particleEmitterSpark = this.particleFactory.create((AnimatedParticleEmitterSettings)this.particleEmitterRepository.find("fx_sparks"));
                    Animation<TextureRegion> drillAnimation = new Animation<TextureRegion>(0.1f, this.dataPack.getTextureAtlas().findRegions(settings.moduleSettings.textureRegion));
                    drillAnimation.setPlayMode(Animation.PlayMode.LOOP);
                    MiningDrillGraphics miningDrillGraphics = new MiningDrillGraphics();
                    miningDrillGraphics.setDrillAnimation(drillAnimation);
                    miningDrillGraphics.setSmokeEmitterLeft(particleEmitterSmokeLeft);
                    miningDrillGraphics.setSmokeEmitterRight(particleEmitterSmokeRight);
                    miningDrillGraphics.setSparkEmitter(particleEmitterSpark);
                    miningDrillGraphics.setDrillSound(AstraXApp.astraX.getSfxSoundManager().createSpatialSound(settings.moduleSettings.drillSettings.drillSound));
                    miningDrillGraphics.setPosition(posX - 8.0f, posY - 8.0f);
                    satelliteGraphics.addMiningDrillGraphics(new Vector2i(x, y), miningDrillGraphics);
                } else {
                    satelliteGraphics.addTexture(this.dataPack.getTextureAtlas().findRegion(settings.moduleSettings.textureRegion), settings.tint, posX, posY, x, y, -settings.orientation.getRotationDegrees(), 1.0f);
                }
                if (settings.moduleSettings.thrusterSettings == null) continue;
                AnimatedParticleEmitter particleEmitter = this.particleFactory.create((AnimatedParticleEmitterSettings)this.particleEmitterRepository.find(settings.moduleSettings.thrusterSettings.particleEmitter));
                AnimationStateGraphics thrusterAnimationGraphics = new AnimationStateGraphics(lowThrottle, midThrottle, fullThrottle);
                ThrusterGraphics thrusterGraphics = new ThrusterGraphics(thrusterAnimationGraphics, particleEmitter);
                thrusterGraphics.setPosition(posX - 8.0f, posY - 8.0f);
                thrusterGraphics.configureNozzle(-settings.orientation.getRotationDegrees());
                thrusterGraphics.setEngineSound(AstraXApp.astraX.getSfxSoundManager().createSpatialSound(settings.moduleSettings.thrusterSettings.engineSound));
                thrusterGraphics.setStartSound(AstraXApp.astraX.getSfxSoundManager().createSpatialSound(settings.moduleSettings.thrusterSettings.startupSound));
                satelliteGraphics.addThrusterGraphics(new Vector2i(x, y), thrusterGraphics);
            }
        }
        satelliteGraphics.setAstraXRenderContext(this.worldRenderContext);
        return satelliteGraphics;
    }

    @Override
    public SatelliteGraphics create(Object satelliteGraphicsSettings) {
        return null;
    }

    private Animation<TextureAtlas.AtlasRegion> createExhaustAnimation(TextureAtlas.AtlasRegion ... exhaust) {
        Animation<TextureAtlas.AtlasRegion> exhaustAnimation = new Animation<TextureAtlas.AtlasRegion>(0.01f, exhaust);
        exhaustAnimation.setPlayMode(Animation.PlayMode.LOOP);
        return exhaustAnimation;
    }
}

