/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.particles;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.neutronio.astrax.gfx.particles.Particle;

public abstract class AbstractParticle
implements Particle {
    protected float maxLifetime;
    protected float time;
    protected float rotation;
    protected float x;
    protected float y;
    protected boolean active = true;
    protected float delay = 0.0f;
    protected float spread;
    protected float angularVelocity = 0.0f;
    protected float dirx;
    protected float diry;
    protected Animation<? extends TextureRegion> animation;

    public float getMaxLifetime() {
        return this.maxLifetime;
    }

    public void setMaxLifetime(float maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getDelay() {
        return this.delay;
    }

    public void setDelay(float delay) {
        this.delay = delay;
    }

    public float getSpread() {
        return this.spread;
    }

    public void setSpread(float spread) {
        this.spread = spread;
    }

    public float getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(float angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public float getDirx() {
        return this.dirx;
    }

    public void setDirx(float dirx) {
        this.dirx = dirx;
    }

    public float getDiry() {
        return this.diry;
    }

    public void setDiry(float diry) {
        this.diry = diry;
    }

    @Override
    public void setAnimation(Animation<? extends TextureRegion> animation) {
        this.animation = animation;
    }

    @Override
    public boolean isAlive() {
        return this.time < this.maxLifetime;
    }

    @Override
    public TextureRegion getTexture() {
        float percent = this.time / this.maxLifetime * this.animation.getAnimationDuration();
        return this.animation.getKeyFrame(percent);
    }

    @Override
    public void update(float delta) {
        this.time += delta;
        if (this.active) {
            this.x += this.dirx * delta;
            this.y += this.diry * delta;
            this.rotation += this.angularVelocity * delta;
        } else if (this.time > this.delay) {
            this.time = 0.0f;
            this.active = true;
        }
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getScaleX() {
        return 1.0f;
    }

    @Override
    public float getScaleY() {
        return 1.0f;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }
}

