/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.particles;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.neutronio.astrax.gfx.particles.Particle;

public class AnimatedParticle
implements Particle {
    protected float maxLifetime;
    protected float time;
    protected float rotation;
    protected float x;
    protected float y;
    protected boolean active = true;
    protected float delay = 0.0f;
    protected float spread;
    protected float angularVelocity = 0.0f;
    protected float dirx;
    protected float diry;
    protected Animation<? extends TextureRegion> animation;

    public AnimatedParticle(Animation animation) {
        this.animation = animation;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getScaleX() {
        return 1.0f;
    }

    @Override
    public float getScaleY() {
        return 1.0f;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isAlive() {
        return this.time < this.maxLifetime;
    }

    @Override
    public TextureRegion getTexture() {
        float percent = this.time / this.maxLifetime * this.animation.getAnimationDuration();
        return this.animation.getKeyFrame(percent);
    }

    @Override
    public void update(float delta) {
        this.time += delta;
        if (this.active) {
            this.x += this.dirx * delta;
            this.y += this.diry * delta;
            this.rotation += this.angularVelocity * delta;
        }
    }

    @Override
    public void setAnimation(Animation<? extends TextureRegion> animation) {
    }
}

