/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.particles;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.gfx.AnimatedParticleEmitterSettings;
import com.neutronio.astrax.gfx.particles.AnimatedParticle;
import com.neutronio.astrax.util.MathUtil;
import com.neutronio.astrax.util.Ranged;
import java.util.ArrayList;
import java.util.List;

public class AnimatedParticleEmitter
extends Actor {
    protected boolean active;
    protected boolean continuous;
    protected int particleAmount = 50;
    protected List<AnimatedParticle> particles = new ArrayList<AnimatedParticle>();
    protected Animation<? extends TextureRegion> animation;
    protected Ranged<Float> angularVelocity = new Ranged<Float>(Float.valueOf(30.0f), Float.valueOf(20.0f));
    protected Ranged<Float> velocity = new Ranged<Float>(Float.valueOf(70.0f), Float.valueOf(5.0f));
    protected Ranged<Float> spread = new Ranged<Float>(Float.valueOf(1.1f), Float.valueOf(0.9f));
    protected Ranged<Float> delay = new Ranged<Float>(Float.valueOf(0.3f), Float.valueOf(0.1f));
    protected Ranged<Float> life = new Ranged<Float>(Float.valueOf(30.0f), Float.valueOf(20.0f));
    protected Ranged<Float> direction = new Ranged<Float>(Float.valueOf(360.0f), Float.valueOf(0.0f));
    protected float maxEmissionRate = 10.0f;
    protected float emissionRate = 10.0f;
    protected float currentEmissionRate;
    protected AnimatedParticleEmitterSettings settings;

    public AnimatedParticleEmitter copy() {
        AnimatedParticleEmitter copy = new AnimatedParticleEmitter();
        copy.setSettings(this.settings);
        copy.animation = this.animation;
        copy.active = this.active;
        copy.continuous = this.continuous;
        copy.particleAmount = this.particleAmount;
        copy.angularVelocity.set(this.angularVelocity.getMax(), this.angularVelocity.getMin());
        copy.velocity.set(this.velocity.getMax(), this.velocity.getMin());
        copy.spread.set(this.spread.getMax(), this.spread.getMin());
        copy.delay.set(this.delay.getMax(), this.delay.getMin());
        copy.life.set(this.life.getMax(), this.life.getMin());
        copy.direction.set(this.direction.getMax(), this.direction.getMin());
        copy.emissionRate = this.emissionRate;
        copy.maxEmissionRate = this.maxEmissionRate;
        copy.currentEmissionRate = this.currentEmissionRate;
        copy.populateWithParticles();
        return copy;
    }

    public AnimatedParticleEmitterSettings getSettings() {
        return this.settings;
    }

    public void setSettings(AnimatedParticleEmitterSettings settings) {
        this.settings = settings;
    }

    public void setEmissionRate(float emissionRate) {
        this.emissionRate = emissionRate;
    }

    public float getMaxEmissionRate() {
        return this.maxEmissionRate;
    }

    public void setMaxEmissionRate(float maxEmissionRate) {
        this.maxEmissionRate = maxEmissionRate;
    }

    public int getParticleAmount() {
        return this.particleAmount;
    }

    public void setParticleAmount(int particleAmount) {
        this.particleAmount = particleAmount;
    }

    public Ranged<Float> getAngularVelocity() {
        return this.angularVelocity;
    }

    public Ranged<Float> getVelocity() {
        return this.velocity;
    }

    public Ranged<Float> getSpread() {
        return this.spread;
    }

    public Ranged<Float> getDelay() {
        return this.delay;
    }

    public Ranged<Float> getLife() {
        return this.life;
    }

    public Ranged<Float> getDirection() {
        return this.direction;
    }

    private void updateActive() {
        for (AnimatedParticle particle : this.particles) {
            particle.active = this.active;
        }
    }

    protected void setInitialParticleMetaData(AnimatedParticle particle) {
        particle.maxLifetime = MathUtil.getRandom(this.getLife()).floatValue();
        particle.angularVelocity = MathUtil.getRandom(this.getAngularVelocity()).floatValue();
        particle.delay = MathUtil.getRandom(this.getDelay()).floatValue();
        particle.spread = MathUtil.getRandom(this.getSpread()).floatValue();
    }

    protected void setInitialParticlePosition(AnimatedParticle particle) {
        particle.x = 0.0f;
        particle.y = 0.0f;
    }

    protected void setInitialParticleVelocity(AnimatedParticle particle) {
        Vector2 dir = MathUtil.getDirectionalVector(MathUtils.random(this.getVelocity().getMin().floatValue(), this.getVelocity().getMax().floatValue()) * 3.0f, (float)Math.PI / 180 * MathUtils.random(this.getDirection().getMin().floatValue() * MathUtils.random(this.getSpread().getMin().floatValue(), this.getSpread().getMax().floatValue()), this.getDirection().getMax().floatValue() * MathUtils.random(this.getSpread().getMin().floatValue(), this.getSpread().getMax().floatValue())));
        particle.diry = dir.x;
        particle.dirx = dir.y;
    }

    private void deactivateParticle(AnimatedParticle particle) {
        particle.active = false;
    }

    private void activateParticle(AnimatedParticle particle) {
        this.currentEmissionRate += 1.0f;
        particle.setX(0.0f);
        particle.setY(0.0f);
        particle.time = 0.0f;
        particle.rotation = 0.0f;
        particle.active = true;
        this.setInitialParticleMetaData(particle);
        this.setInitialParticlePosition(particle);
        this.setInitialParticleVelocity(particle);
    }

    public void start() {
        this.active = true;
        this.updateActive();
        for (AnimatedParticle particle : this.particles) {
            particle.time = 0.0f;
            this.activateParticle(particle);
        }
    }

    public void stop() {
        this.active = false;
        this.updateActive();
    }

    public void populateWithParticles() {
        this.particles.clear();
        for (int i2 = 0; i2 < this.getParticleAmount(); ++i2) {
            AnimatedParticle particle = new AnimatedParticle(this.animation);
            this.particles.add(particle);
        }
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean continuous) {
        this.continuous = continuous;
    }

    public List<AnimatedParticle> getParticles() {
        return this.particles;
    }

    public void setParticles(List<AnimatedParticle> particles) {
        this.particles = particles;
        this.updateActive();
    }

    public void setAnimation(Animation<? extends TextureRegion> animation) {
        this.animation = animation;
        for (AnimatedParticle particle : this.particles) {
            particle.animation = animation;
        }
    }

    public Animation<? extends TextureRegion> getAnimation() {
        return this.animation;
    }

    @Override
    public void act(float delta) {
        this.currentEmissionRate *= 0.8f;
        for (AnimatedParticle particle : this.particles) {
            particle.update(delta);
            if (this.continuous && this.active) {
                if (particle.isAlive() || !(this.currentEmissionRate < this.emissionRate)) continue;
                this.activateParticle(particle);
                continue;
            }
            if (!(this.currentEmissionRate < this.emissionRate) || !this.active) continue;
            this.activateParticle(particle);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.particles.isEmpty()) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "No particles to render!");
        }
        for (AnimatedParticle particle : this.particles) {
            if (!particle.isAlive()) continue;
            TextureRegion texture = particle.getTexture();
            batch.setColor(this.getColor());
            batch.draw(texture, this.getX() + particle.getX() - (float)texture.getRegionWidth() / 2.0f, this.getY() + particle.getY() - (float)texture.getRegionHeight() / 2.0f, (float)texture.getRegionWidth() / 2.0f, (float)texture.getRegionHeight() / 2.0f, texture.getRegionWidth(), texture.getRegionHeight(), this.getScaleX(), this.getScaleY(), this.getRotation() + particle.getRotation());
        }
        batch.setColor(Color.WHITE);
    }
}

