/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.gfx.textures;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import java.util.ArrayList;
import java.util.List;

public class MaskedSprite
extends Actor {
    private SpriteBatch maskBatch;
    private Sprite maskSprite;
    private List<Sprite> sprites = new ArrayList<Sprite>();

    public MaskedSprite(SpriteBatch batch) {
        this.maskBatch = batch;
    }

    private void drawMask(Batch maskBatch, Sprite sprite) {
        float width = this.getWidth();
        float height = this.getHeight();
        float x = this.getX();
        float y = this.getY();
        Gdx.gl.glColorMask(false, false, false, true);
        maskBatch.setBlendFunction(1, 0);
        this.maskSprite.draw(maskBatch);
        sprite.draw(maskBatch);
        maskBatch.setBlendFunction(0, 770);
        this.maskSprite.draw(maskBatch);
        maskBatch.flush();
    }

    private void drawIntoMask(Batch maskBatch, Sprite sprite) {
        float width = this.getWidth();
        float height = this.getHeight();
        float x = this.getX();
        float y = this.getY();
        Gdx.gl.glColorMask(true, true, true, true);
        maskBatch.setBlendFunction(772, 773);
        this.maskSprite.draw(maskBatch);
        sprite.draw(maskBatch);
        maskBatch.flush();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.maskSprite != null) {
            this.maskSprite.setPosition(this.getX(), this.getY());
            this.maskBatch.setProjectionMatrix(batch.getProjectionMatrix());
            this.maskBatch.begin();
            for (Sprite sprite : this.sprites) {
                this.drawIntoMask(this.maskBatch, sprite);
            }
            this.maskBatch.end();
        }
    }
}

