/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.input;

import com.badlogic.gdx.Input;

public enum DeviceType {
    KEYBOARD,
    MOUSE,
    GAMEPAD;


    public static String getInputName(DeviceType type, int code) {
        switch (type) {
            case KEYBOARD: {
                return Input.Keys.toString(code);
            }
            case MOUSE: 
            case GAMEPAD: {
                return DeviceType.getButtonName(code);
            }
        }
        return "n.A";
    }

    public static String getButtonName(int buttonCode) {
        switch (buttonCode) {
            case 0: {
                return "Left";
            }
            case 1: {
                return "Right";
            }
            case 2: {
                return "Middle";
            }
            case 3: {
                return "Back";
            }
            case 4: {
                return "Forward";
            }
        }
        return "Button " + buttonCode;
    }
}

