/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.input;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.input.ClickInput;
import com.neutronio.astrax.input.ContinuousKeyInput;
import com.neutronio.astrax.input.InputCatcher;
import com.neutronio.astrax.input.KeyInput;
import com.neutronio.astrax.input.ScrollInput;
import com.neutronio.astrax.input.actions.ClickedAction;
import com.neutronio.astrax.input.actions.ContinuousAction;
import com.neutronio.astrax.input.actions.InputAction;
import com.neutronio.astrax.input.actions.KeyTypedAction;
import com.neutronio.astrax.input.actions.ScrollAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class InputProcessor<T>
extends InputListener {
    protected T parent;
    private Map<String, InputAction<T>> allActions = new LinkedHashMap<String, InputAction<T>>();
    private Map<String, InputCatcher> allInputs = new HashMap<String, InputCatcher>();
    private Map<KeyInput, KeyTypedAction<T>> keyActions = new LinkedHashMap<KeyInput, KeyTypedAction<T>>();
    private Map<ContinuousKeyInput, ContinuousAction<T>> continuousActions = new LinkedHashMap<ContinuousKeyInput, ContinuousAction<T>>();
    private Map<ClickInput, ClickedAction<T>> mouseActions = new LinkedHashMap<ClickInput, ClickedAction<T>>();
    private Map<ScrollInput, ScrollAction<T>> scrollActions = new LinkedHashMap<ScrollInput, ScrollAction<T>>();

    public InputProcessor(T parent) {
        this.parent = parent;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }

    public InputCatcher getMappedInput(String actionName) {
        return this.allInputs.get(actionName);
    }

    public InputAction getMappedAction(String actionName) {
        return this.allActions.get(actionName);
    }

    public void addAction(String actionName, InputAction<T> action) {
        this.allActions.put(actionName, action);
    }

    public void initializeMappings(KeyMappingSettings keyMappingSettings) {
        this.keyActions.clear();
        this.continuousActions.clear();
        this.mouseActions.clear();
        this.scrollActions.clear();
        this.allInputs.clear();
        for (KeyMappingSettings.KeyMapping mapping : keyMappingSettings.getMappings()) {
            InputAction<T> inputAction = this.allActions.get(mapping.actionName);
            if (inputAction instanceof ClickedAction) {
                ClickedAction clickAction = (ClickedAction)inputAction;
                ClickInput clickInput = new ClickInput(mapping.code, mapping.actionName);
                mapping.device = clickInput.deviceType;
                this.addClickedAction(clickInput, clickAction);
                this.allInputs.put(mapping.actionName, clickInput);
                continue;
            }
            if (inputAction instanceof KeyTypedAction) {
                KeyTypedAction keyTypedAction = (KeyTypedAction)inputAction;
                KeyInput keyInput = new KeyInput(mapping.code, mapping.actionName);
                mapping.device = keyInput.deviceType;
                this.addKeyAction(keyInput, keyTypedAction);
                this.allInputs.put(mapping.actionName, keyInput);
                continue;
            }
            if (inputAction instanceof ContinuousAction) {
                ContinuousAction continuousAction = (ContinuousAction)inputAction;
                ContinuousKeyInput continuousKeyInput = new ContinuousKeyInput(mapping.code, mapping.actionName);
                mapping.device = continuousKeyInput.deviceType;
                this.addContinuousKeyAction(continuousKeyInput, continuousAction);
                this.allInputs.put(mapping.actionName, continuousKeyInput);
                continue;
            }
            if (!(inputAction instanceof ScrollAction)) continue;
            ScrollAction scrollAction = (ScrollAction)inputAction;
            ScrollInput scrollInput = new ScrollInput(mapping.code, mapping.actionName);
            mapping.device = scrollInput.deviceType;
            this.addScrollAction(scrollInput, scrollAction);
            this.allInputs.put(mapping.actionName, scrollInput);
        }
    }

    public void addKeyAction(KeyInput input, KeyTypedAction<T> action) {
        this.keyActions.put(input, action);
    }

    public void addContinuousKeyAction(ContinuousKeyInput input, ContinuousAction<T> action) {
        this.continuousActions.put(input, action);
    }

    public void addClickedAction(ClickInput input, ClickedAction<T> action) {
        this.mouseActions.put(input, action);
    }

    public void addScrollAction(ScrollInput input, ScrollAction<T> action) {
        this.scrollActions.put(input, action);
    }

    public void update(float delta) {
        for (Map.Entry<ContinuousKeyInput, ContinuousAction<T>> entry : this.continuousActions.entrySet()) {
            if (!entry.getKey().isPressed()) continue;
            entry.getValue().doAction(this.parent);
        }
    }

    @Override
    public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
        for (Map.Entry<ClickInput, ClickedAction<T>> entry : this.mouseActions.entrySet()) {
            if (entry.getKey().getKeyCode() != button) continue;
            return entry.getValue().doAction(this.parent);
        }
        return false;
    }

    @Override
    public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
        Iterator<Map.Entry<ScrollInput, ScrollAction<T>>> iterator = this.scrollActions.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<ScrollInput, ScrollAction<T>> entry = iterator.next();
            return entry.getValue().doAction(this.parent, amountX, amountY);
        }
        return false;
    }

    @Override
    public boolean keyDown(InputEvent event, int keycode) {
        for (Map.Entry<ContinuousKeyInput, ContinuousAction<T>> entry : this.continuousActions.entrySet()) {
            if (entry.getKey().getKeyCode() != keycode) continue;
            entry.getKey().setPressed(true);
        }
        for (Map.Entry<InputCatcher, InputAction> entry : this.keyActions.entrySet()) {
            if (((KeyInput)entry.getKey()).keyCode != keycode) continue;
            return ((KeyTypedAction)entry.getValue()).doAction(this.parent);
        }
        return false;
    }

    @Override
    public boolean keyUp(InputEvent event, int keycode) {
        for (Map.Entry<ContinuousKeyInput, ContinuousAction<T>> entry : this.continuousActions.entrySet()) {
            if (entry.getKey().getKeyCode() != keycode) continue;
            entry.getKey().setPressed(false);
        }
        return false;
    }
}

