/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import java.util.HashMap;
import java.util.Map;

public class ReactiveCursor {
    Map<String, Cursor> cursors = new HashMap<String, Cursor>();

    public ReactiveCursor() {
        this.addCursor("default", "cursors/cursor.png", 0, 0);
        this.addCursor("edit", "cursors/cursor_edit.png", 0, 0);
        this.addCursor("paint", "cursors/cursor_paint.png", 0, 0);
        this.addCursor("inspect", "cursors/cursor_inspect.png", 0, 0);
        this.addCursor("erase", "cursors/cursor_erase.png", 0, 0);
        this.addCursor("select", "cursors/cursor_select.png", 0, 0);
        this.addCursor("text", "cursors/cursor_text.png", 16, 16);
        this.addCursor("cross", "cursors/cursor_cross.png", 16, 16);
    }

    private void addCursor(String name, String path, int xHotspot, int yHotspot) {
        Pixmap pixmap = new Pixmap(Gdx.files.internal(path));
        Cursor cursor = Gdx.graphics.newCursor(pixmap, xHotspot, yHotspot);
        pixmap.dispose();
        this.cursors.put(name, cursor);
    }

    public void resetCursor() {
        this.setActiveCursor("default");
    }

    public void setActiveCursor(String cursorName) {
        Cursor cursor = this.cursors.get(cursorName);
        if (cursor != null) {
            Gdx.graphics.setCursor(cursor);
        }
    }
}

