/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.input;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.Docking;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockingState;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockingSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.input.actions.KeyTypedAction;
import com.neutronio.astrax.input.actions.ScrollAction;
import com.neutronio.astrax.ui.commons.text.Wiki;
import com.neutronio.astrax.ui.game.inventory.CargoSystemPanel;
import com.neutronio.astrax.ui.game.menu.MapTab;

public class SpaceScreenActions {
    public static KeyTypedAction<SpaceScreen> getPause() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                if (screen.getTabMenu().isVisible()) {
                    return false;
                }
                if (screen.isGamePaused()) {
                    screen.resumeGame();
                } else {
                    screen.pauseGame();
                }
                return true;
            }
        };
    }

    public static ScrollAction<SpaceScreen> getZoomIn() {
        return new ScrollAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                if (screen.getTabMenu().isVisible() || screen.isPaused()) {
                    return false;
                }
                screen.getPanningCamera().zoomIn(2.0f);
                return true;
            }

            @Override
            public boolean doAction(SpaceScreen screen, float amountX, float amountY) {
                if (screen.getTabMenu().isVisible() || screen.isPaused()) {
                    return false;
                }
                screen.getPanningCamera().zoom(amountY);
                return false;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getZoomReset() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                screen.getPanningCamera().resetZoom();
                return true;
            }
        };
    }

    public static ScrollAction<SpaceScreen> getZoomOut() {
        return new ScrollAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                if (screen.getTabMenu().isVisible() || screen.isPaused()) {
                    return false;
                }
                screen.getPanningCamera().zoomOut(2.0f);
                return true;
            }

            @Override
            public boolean doAction(SpaceScreen screen, float amountX, float amountY) {
                if (screen.getTabMenu().isVisible() || screen.isPaused()) {
                    return false;
                }
                screen.getPanningCamera().zoomIn(amountY);
                return false;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getToggleDrill() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                Satellite playerCraft = (Satellite)screen.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel();
                if (playerCraft.hasSystem(MiningSystem.class)) {
                    MiningSystem system = playerCraft.getSystem(MiningSystem.class);
                    system.toggleMiningDrills();
                    return true;
                }
                return false;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getExitMenu() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                if (!screen.getTabMenu().isVisible()) {
                    screen.showTabMenuWith(MapTab.class);
                    screen.gainFocusMenu();
                    return true;
                }
                screen.hideTabMenu();
                screen.gainFocusPlayer();
                return true;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getChangeTarget() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                Satellite satellite = (Satellite)screen.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel();
                DiscoverySystem system = satellite.getSystem(DiscoverySystem.class);
                system.getProximitySensor().calculateTargetInformation();
                TargetSorter.Target closestTarget = system.getProximitySensor().getClosestTarget();
                if (closestTarget != null) {
                    satellite.getSystem(DiscoverySystem.class).getTargetComputer().setCurrentTarget(closestTarget.getDiscoveryTarget(), SpaceScreenActions.class);
                } else {
                    satellite.getSystem(DiscoverySystem.class).getTargetComputer().setCurrentTarget(null, SpaceScreenActions.class);
                }
                return true;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getGameContextAction() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                DiscoveryTarget selectedTarget = screen.getAstraxGame().getLocalPlayer().getCurrentTarget();
                if (selectedTarget != null) {
                    DockingSystem dockingSystem;
                    SatelliteTarget station;
                    if (selectedTarget.target instanceof SatelliteTarget && ((Satellite)(station = (SatelliteTarget)selectedTarget.target).getModel()).hasSystem(DockingSystem.class) && (dockingSystem = ((Satellite)screen.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel()).getSystem(DockingSystem.class)).getDockingState() == DockingState.UNDOCKED) {
                        Docking dockingLogic = screen.getAstraxGame().getWorld().getGameLogic(Docking.class);
                        if (dockingLogic.inRange(station, screen.getAstraxGame().getLocalPlayer().getPlayerTarget())) {
                            Message message = dockingLogic.dock(station, screen.getAstraxGame().getLocalPlayer().getPlayerTarget());
                            screen.getApp().showMessageAlert(message);
                            screen.gainFocusPlayer();
                            return true;
                        }
                        screen.getApp().showErrorAlert(AstraXApp.astraX.getComponentFactory().translate("game_message_dock_out_of_range"));
                    }
                    ((Satellite)screen.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel()).scanTarget(selectedTarget);
                    return true;
                }
                return false;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getShowGalaxyTab() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                if (!screen.getTabMenu().isVisible()) {
                    screen.showTabMenuWith(MapTab.class);
                    screen.gainFocusMenu();
                    return true;
                }
                return false;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getShowMapTab() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                if (!screen.getTabMenu().isVisible()) {
                    screen.showTabMenuWith(MapTab.class);
                    screen.gainFocusMenu();
                    return true;
                }
                return false;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getShowInventoryTab() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                if (!screen.getTabMenu().isVisible()) {
                    screen.showTabMenuWith(CargoSystemPanel.class);
                    screen.gainFocusMenu();
                    return true;
                }
                return false;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getShowHelpTab() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                if (!screen.getTabMenu().isVisible()) {
                    screen.showTabMenuWith(Wiki.class);
                    screen.gainFocusMenu();
                    return true;
                }
                return false;
            }
        };
    }

    public static KeyTypedAction<SpaceScreen> getShowDebugDraw() {
        return new KeyTypedAction<SpaceScreen>(){

            @Override
            public boolean doAction(SpaceScreen screen) {
                boolean showDebug = !screen.getHudStage().isDebugAll();
                screen.getHudStage().setDebugAll(showDebug);
                screen.getUiStage().setDebugAll(showDebug);
                screen.getWorldStage().setDebugAll(showDebug);
                screen.getApp().getGameStage().setDebugAll(showDebug);
                return true;
            }
        };
    }
}

