/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.input.actions;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.input.actions.KeyAction;
import com.neutronio.astrax.input.actions.KeyMappingAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class KeyActionProcessor<T> {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected T parent;
    private Map<String, KeyAction<T>> allActions = new HashMap<String, KeyAction<T>>();
    protected Map<Integer, KeyMappingAction<T>> mappedActions = new HashMap<Integer, KeyMappingAction<T>>();

    public KeyActionProcessor(T parent) {
        this.parent = parent;
    }

    public boolean addAction(KeyAction<T> action) {
        if (this.allActions.containsKey(action.getKeycode())) {
            return false;
        }
        this.allActions.put(action.getActionName(), action);
        return true;
    }

    public void addActions(List<KeyAction<T>> actions) {
        for (KeyAction<T> action : actions) {
            if (this.addAction(action)) continue;
            this.logger.log(Level.WARNING, "Could not add mapping as keycode already exists. Affected action: " + action.getActionName());
        }
    }

    public void remapKeyCodes(KeyMappingSettings mappings) {
        this.mappedActions.clear();
        for (KeyMappingSettings.KeyMapping mapping : mappings.getMappings()) {
            KeyAction<T> keyAction = this.allActions.get(mapping.actionName);
            if (keyAction == null) {
                throw new AstraXException(AstraXException.ErrorCode.E3000, "Mapping '" + mapping.actionName + "'");
            }
            this.mappedActions.put(mapping.code, new KeyMappingAction<T>(keyAction, mapping));
        }
    }

    public boolean invoke(InputEvent.Type type, int keycode) {
        KeyMappingAction<T> mappedAction = this.mappedActions.get(keycode);
        if (mappedAction != null) {
            return mappedAction.keyAction.doAction(this.parent);
        }
        return false;
    }
}

