/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.input.controller;

import com.badlogic.gdx.Gdx;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.PositionController;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.PropulsionSystem;
import com.neutronio.astrax.input.InputProcessor;
import com.neutronio.astrax.input.actions.ContinuousAction;
import com.neutronio.astrax.input.actions.InputAction;
import com.neutronio.astrax.input.actions.KeyTypedAction;

public class PropulsionUserController
extends PositionController {
    private PropulsionSystem propulsionSystem;
    private InputProcessor<PropulsionSystem> inputProcessor;
    private boolean running = false;

    public PropulsionUserController(PropulsionSystem propulsionSystem) {
        if (propulsionSystem == null) {
            throw new NullPointerException("Propulsion System cannot be null");
        }
        this.propulsionSystem = propulsionSystem;
    }

    public void setup(KeyMappingSettings settings) {
        this.inputProcessor = new InputProcessor<PropulsionSystem>(this.propulsionSystem);
        this.inputProcessor.addAction("astrax:satellite:accelerate", (InputAction<PropulsionSystem>)new ContinuousAction<PropulsionSystem>(){

            @Override
            public boolean doAction(PropulsionSystem system) {
                system.throttleIncrease(Gdx.graphics.getDeltaTime() * 20.0f);
                return false;
            }
        });
        this.inputProcessor.addAction("astrax:satellite:decelerate", (InputAction<PropulsionSystem>)new ContinuousAction<PropulsionSystem>(){

            @Override
            public boolean doAction(PropulsionSystem system) {
                system.throttleDecrease(Gdx.graphics.getDeltaTime() * 5.0f);
                return false;
            }
        });
        this.inputProcessor.addAction("astrax:satellite:rotateLeft", (InputAction<PropulsionSystem>)new ContinuousAction<PropulsionSystem>(){

            @Override
            public boolean doAction(PropulsionSystem system) {
                system.rotate(1.0f, Gdx.graphics.getDeltaTime(), 20.0f);
                return false;
            }
        });
        this.inputProcessor.addAction("astrax:satellite:rotateRight", (InputAction<PropulsionSystem>)new ContinuousAction<PropulsionSystem>(){

            @Override
            public boolean doAction(PropulsionSystem system) {
                system.rotate(-1.0f, Gdx.graphics.getDeltaTime(), 20.0f);
                return false;
            }
        });
        this.inputProcessor.addAction("astrax:satellite:toggleEngines", (InputAction<PropulsionSystem>)new KeyTypedAction<PropulsionSystem>(){

            @Override
            public boolean doAction(PropulsionSystem system) {
                if (PropulsionUserController.this.running) {
                    PropulsionUserController.this.running = false;
                    system.stop();
                } else {
                    PropulsionUserController.this.running = true;
                    system.start();
                }
                return true;
            }
        });
        this.inputProcessor.initializeMappings(settings);
    }

    public InputProcessor<PropulsionSystem> getInputProcessor() {
        return this.inputProcessor;
    }

    @Override
    public void update(float delta) {
        this.inputProcessor.update(delta);
    }
}

