/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.io.FileHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class AstraXFiles
implements FileHandler {
    public static final String REGEX_PATTERN = "^[A-Za-z0-9._ ]{1,100}$";
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

    public static FileHandle toGdxFileHandle(String path, FileHandler.FileLocation fileLocation) {
        if (Gdx.files == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "LibGdx");
        }
        switch (fileLocation) {
            case INTERNAL: {
                return Gdx.files.internal(path);
            }
            case CLASSPATH: {
                return Gdx.files.classpath(path);
            }
            case EXTERNAL: {
                return Gdx.files.external(path);
            }
            case ABSOLUTE: {
                return Gdx.files.absolute(path);
            }
            case LOCAL: {
                return Gdx.files.local(path);
            }
        }
        return null;
    }

    @Override
    public boolean deleteFile(AstraXFile file) {
        if (file == null) {
            return false;
        }
        this.logger.fine("Delete File: " + file.path);
        boolean delete = file.file.delete();
        if (delete && file.file.exists()) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "File was allegedly deleted but still exists?!");
        }
        return delete;
    }

    protected InputStream getReader(String path, FileHandler.FileLocation location) throws GdxRuntimeException {
        if (Gdx.files == null) {
            try {
                return new FileInputStream(path.replace('\\', '/'));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            return AstraXFiles.toGdxFileHandle(path, location).read();
        }
        return null;
    }

    @Override
    public List<AstraXFile> readFilesInDirectory(String path, FileHandler.FileLocation location, String glob) throws IOException, GdxRuntimeException {
        FileHandle fileHandle = AstraXFiles.toGdxFileHandle(path, location);
        DirectoryStream<Path> dirs = Files.newDirectoryStream(fileHandle.file().toPath(), glob);
        ArrayList<AstraXFile> directories = new ArrayList<AstraXFile>();
        for (Path directory : dirs) {
            directories.add(new AstraXFile(directory.toFile(), path + "/" + directory.getFileName(), location));
        }
        dirs.close();
        return directories;
    }

    @Override
    public StringBuilder readFileContents(String path, FileHandler.FileLocation location) throws IOException, GdxRuntimeException {
        InputStream stream = this.getReader(path, location);
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String currentLine = "";
        while ((currentLine = reader.readLine()) != null) {
            builder.append(currentLine);
        }
        reader.close();
        return builder;
    }

    @Override
    public FileHandler.State saveFileContents(String data, String path, FileHandler.FileLocation location) throws IOException {
        return this.saveFileContents(data, path, location, false);
    }

    @Override
    public FileHandler.State saveFileContents(String data, String path, FileHandler.FileLocation location, boolean overwrite) throws IOException {
        FileHandle fileHandle = AstraXFiles.toGdxFileHandle(path, location);
        File file = fileHandle.file();
        FileHandler.State state = null;
        if (!file.exists()) {
            file.createNewFile();
            this.save(file, data);
            state = FileHandler.State.SAVED;
        } else if (overwrite) {
            this.save(file, data);
            state = FileHandler.State.SAVED;
        } else {
            state = FileHandler.State.ABORTED;
        }
        return state;
    }

    @Override
    public FileHandler.State saveFileBinary(Serializable savable, String path, FileHandler.FileLocation location) {
        FileHandle fileHandle = AstraXFiles.toGdxFileHandle(path, location);
        FileOutputStream fileOutputStream = null;
        FileHandler.State state = null;
        try {
            fileOutputStream = new FileOutputStream(fileHandle.path());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(savable);
            objectOutputStream.flush();
            objectOutputStream.close();
            state = FileHandler.State.SAVED;
        }
        catch (IOException e) {
            e.printStackTrace();
            state = FileHandler.State.FAILED;
        }
        return state;
    }

    public FileHandler.State saveFileBinary(Serializable savable, String fileName, FileHandle parentDirectory) {
        FileOutputStream fileOutputStream = null;
        FileHandler.State state = null;
        try {
            parentDirectory.mkdirs();
            fileOutputStream = new FileOutputStream(parentDirectory.child(fileName).path());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(savable);
            objectOutputStream.flush();
            objectOutputStream.close();
            state = FileHandler.State.SAVED;
        }
        catch (IOException e) {
            e.printStackTrace();
            state = FileHandler.State.FAILED;
        }
        return state;
    }

    public <T extends Serializable> T readFileBinary(String fileName, FileHandle parentDirectory) {
        FileInputStream fileInputStream = null;
        Serializable loaded = null;
        try {
            fileInputStream = new FileInputStream(parentDirectory.child(fileName).path());
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            loaded = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return (T)loaded;
    }

    @Override
    public <T extends Serializable> T readFileBinary(String path, FileHandler.FileLocation location) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    private void save(File file, String data) throws IOException {
        BufferedWriter writer = null;
        writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        if (writer != null) {
            writer.close();
        }
    }

    public static class AstraXFile
    implements Serializable {
        private static final long serialVersionUID = -4299132363679097821L;
        public transient File file;
        public String path;
        public FileHandler.FileLocation location;

        public AstraXFile(File file, String path, FileHandler.FileLocation location) {
            this.file = file;
            this.path = path;
            this.location = location;
        }
    }
}

