/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.RepositoryFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.json.game.JSONToSatelliteGrid;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class BlueprintLoader {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private FileHandler fileHandler = AstraXApp.astraX.getAstraXFiles();

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public SatelliteGrid load(AstraXFiles.AstraXFile file) throws IOException {
        if (file == null) {
            return null;
        }
        this.logger.fine("Loading spacecraft... ");
        JSONToSatelliteGrid satelliteGridConverter = AstraXApp.astraX.getRepositoryFactory().getDataManager().getConverter(JSONToSatelliteGrid.class);
        StringBuilder builder = this.fileHandler.readFileContents(file.file.getPath(), FileHandler.FileLocation.ABSOLUTE);
        JSONObject spacecraftFile = new JSONObject(builder.toString());
        SatelliteGrid loadedSpacecraft = satelliteGridConverter.convert(spacecraftFile.toMap());
        this.logger.fine("Loaded spacecraft of name: " + loadedSpacecraft.name);
        return loadedSpacecraft;
    }

    public SatelliteGrid load(String path, FileHandler.FileLocation fileLocation) throws IOException {
        if (path == null) {
            return null;
        }
        this.logger.fine("Loading spacecraft... ");
        JSONToSatelliteGrid satelliteGridConverter = AstraXApp.astraX.getRepositoryFactory().getDataManager().getConverter(JSONToSatelliteGrid.class);
        StringBuilder builder = this.fileHandler.readFileContents(path, fileLocation);
        JSONObject spacecraftFile = new JSONObject(builder.toString());
        SatelliteGrid loadedSpacecraft = satelliteGridConverter.convert(spacecraftFile.toMap());
        this.logger.fine("Loaded spacecraft of name: " + loadedSpacecraft.name);
        return loadedSpacecraft;
    }

    public FileHandler.State save(SatelliteGrid satelliteGrid, String basePath, String filename, boolean overwrite) {
        this.logger.log(Level.INFO, "Saving spacecraft to {0}/{1}", new Object[]{basePath, filename});
        Object message = null;
        RepositoryFactory repositoryFactory = AstraXApp.astraX.getRepositoryFactory();
        JSONToSatelliteGrid satelliteGridConverter = repositoryFactory.getDataManager().getConverter(JSONToSatelliteGrid.class);
        try {
            if (!filename.endsWith(".json")) {
                filename = filename + ".json";
            }
            String fullPath = basePath + "/" + filename;
            JSONObject value = satelliteGridConverter.convertToJSON(satelliteGrid);
            return this.fileHandler.saveFileContents(value.toString(2), fullPath, FileHandler.FileLocation.LOCAL, overwrite);
        }
        catch (IOException e) {
            e.printStackTrace();
            return FileHandler.State.FAILED;
        }
    }
}

