/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.FileHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class JavaFileHandler
implements FileHandler {
    @Override
    public boolean deleteFile(AstraXFiles.AstraXFile file) {
        return file.file.delete();
    }

    @Override
    public List<AstraXFiles.AstraXFile> readFilesInDirectory(String path, FileHandler.FileLocation location, String glob) throws IOException, GdxRuntimeException {
        File rootDirectory = new File(path);
        DirectoryStream<Path> dirs = Files.newDirectoryStream(rootDirectory.toPath(), glob);
        ArrayList<AstraXFiles.AstraXFile> directories = new ArrayList<AstraXFiles.AstraXFile>();
        for (Path directory : dirs) {
            directories.add(new AstraXFiles.AstraXFile(directory.toFile(), path, location));
        }
        dirs.close();
        return directories;
    }

    @Override
    public StringBuilder readFileContents(String path, FileHandler.FileLocation location) throws IOException {
        InputStream stream = null;
        StringBuilder builder = new StringBuilder();
        switch (location) {
            case INTERNAL: 
            case CLASSPATH: {
                stream = this.getClass().getClassLoader().getResourceAsStream(path);
                break;
            }
            default: {
                stream = new FileInputStream(path);
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String currentLine = "";
        while ((currentLine = reader.readLine()) != null) {
            builder.append(currentLine);
        }
        reader.close();
        return builder;
    }

    @Override
    public FileHandler.State saveFileContents(String data, String path, FileHandler.FileLocation location) throws IOException {
        return this.saveFileContents(data, path, location, false);
    }

    @Override
    public FileHandler.State saveFileContents(String data, String path, FileHandler.FileLocation location, boolean overwrite) throws IOException {
        File file = new File(path);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(data);
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return FileHandler.State.FAILED;
        }
        return FileHandler.State.SAVED;
    }

    @Override
    public FileHandler.State saveFileBinary(Serializable savable, String path, FileHandler.FileLocation location) {
        Message message = new Message();
        FileOutputStream fileOutputStream = null;
        FileHandler.State state = null;
        try {
            fileOutputStream = new FileOutputStream(path);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(savable);
            objectOutputStream.flush();
            objectOutputStream.close();
            state = FileHandler.State.SAVED;
        }
        catch (IOException e) {
            e.printStackTrace();
            state = FileHandler.State.FAILED;
        }
        return state;
    }

    @Override
    public <T extends Serializable> T readFileBinary(String path, FileHandler.FileLocation location) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(path);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Serializable loaded = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
            return (T)loaded;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

