/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.binary.game.world.galaxy;

import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.TextureCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetCreationSettings;
import com.neutronio.astrax.io.binary.Savable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SavedPlanetCreationSettings
implements Serializable,
Savable {
    private static final long serialVersionUID = -3706176696288099052L;
    private boolean generatedPlanet;
    public String customPlanetID;
    public String entityId;
    public String name;
    public String icon;
    public String description;
    public Float scale;
    public Float axisTilt;
    public String planetClass;
    public String planetType;
    public List<String> traits;
    public List<TextureCreationSettings> textureSettings = new ArrayList<TextureCreationSettings>();
    public boolean useShadowMask = false;

    public SavedPlanetCreationSettings() {
    }

    public SavedPlanetCreationSettings(PlanetCreationSettings creationSettings) {
        this.generatedPlanet = true;
        this.customPlanetID = null;
        this.name = creationSettings.name;
        this.icon = creationSettings.icon;
        this.description = creationSettings.description;
        this.scale = creationSettings.scale;
        this.axisTilt = creationSettings.axisTilt;
        this.planetClass = creationSettings.planetClass.name();
        this.planetType = creationSettings.planetType.name();
        this.traits = Collections.unmodifiableList(creationSettings.traits);
        this.textureSettings = Collections.unmodifiableList(creationSettings.textureSettings);
        this.useShadowMask = creationSettings.useShadowMask;
    }

    public boolean isGeneratedPlanet() {
        return this.generatedPlanet;
    }

    public SavedPlanetCreationSettings(String customPlanetID) {
        this.generatedPlanet = false;
        this.customPlanetID = customPlanetID;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.generatedPlanet);
        if (this.generatedPlanet) {
            oos.writeObject(this.entityId);
            oos.writeObject(this.name);
            oos.writeObject(this.icon);
            oos.writeObject(this.description);
            oos.writeObject(this.scale);
            oos.writeObject(this.axisTilt);
            oos.writeObject(this.planetClass);
            oos.writeObject(this.planetType);
            oos.writeObject(this.traits);
            oos.writeObject(this.textureSettings);
            oos.writeObject(this.useShadowMask);
        } else {
            oos.writeObject(this.customPlanetID);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.generatedPlanet = (Boolean)ois.readObject();
        if (this.generatedPlanet) {
            this.entityId = (String)ois.readObject();
            this.name = (String)ois.readObject();
            this.icon = (String)ois.readObject();
            this.description = (String)ois.readObject();
            this.scale = Float.valueOf(((Float)ois.readObject()).floatValue());
            this.axisTilt = Float.valueOf(((Float)ois.readObject()).floatValue());
            this.planetClass = (String)ois.readObject();
            this.planetType = (String)ois.readObject();
            this.traits = (List)ois.readObject();
            this.textureSettings = (List)ois.readObject();
            this.useShadowMask = (Boolean)ois.readObject();
        } else {
            this.customPlanetID = (String)ois.readObject();
        }
    }
}

