/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.files;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class FileUtils {
    public static void openInFileBrowser(String dir) throws IOException {
        Desktop desktop = Desktop.getDesktop();
        try {
            File dirToOpen = new File(dir);
            desktop.open(dirToOpen);
        }
        catch (IllegalArgumentException iae) {
            System.out.println("File Not Found");
        }
    }

    public static void openInWebBrowser(String url) throws IOException, URISyntaxException {
        String myOS = System.getProperty("os.name").toLowerCase();
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(new URI(url));
        } else {
            Runtime runtime = Runtime.getRuntime();
            if (myOS.contains("mac")) {
                runtime.exec("open " + url);
            } else if (myOS.contains("nix") || myOS.contains("nux")) {
                runtime.exec("xdg-open " + url);
            }
        }
    }
}

