/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json;

import com.neutronio.astrax.io.JSONConverterBase;
import com.neutronio.astrax.io.json.game.DataManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.json.JSONObject;

public class GenericJSONConverter<TYPE>
extends JSONConverterBase<TYPE, Map> {
    private Class<TYPE> convertedClass;

    public GenericJSONConverter(DataManager loader) {
        super(loader);
    }

    public Class<TYPE> getConvertedClass() {
        return this.convertedClass;
    }

    public void setConvertedClass(Class<TYPE> convertedClass) {
        this.convertedClass = convertedClass;
    }

    @Override
    public TYPE convert(Map input) {
        Field[] fields;
        TYPE output = null;
        try {
            output = this.convertedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        for (Field field : fields = this.convertedClass.getDeclaredFields()) {
            if (!input.containsKey(field.getName())) continue;
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(output, input.get(field.getName()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            field.setAccessible(accessible);
        }
        return output;
    }

    @Override
    public JSONObject convertToJSON(TYPE object) {
        Field[] fields;
        JSONObject jsonObject = new JSONObject();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                jsonObject.put(field.getName(), field.get(object));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            field.setAccessible(accessible);
        }
        return jsonObject;
    }
}

