/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.config;

import com.neutronio.astrax.app.datapack.DataPackSettings;
import com.neutronio.astrax.app.datapack.game.GameDifficulty;
import com.neutronio.astrax.app.datapack.game.GameSettings;
import com.neutronio.astrax.io.JSONConverterBase;
import com.neutronio.astrax.io.json.config.app.JSONToDataPackSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.util.JSONUtils;
import com.neutronio.astrax.util.date.Timespan;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONToGameSettings
extends JSONConverterBase<GameSettings, JSONObject> {
    private JSONToDataPackSettings jsonToDataPackSettings = this.getLoader().getConverter(JSONToDataPackSettings.class);

    public JSONToGameSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public GameSettings convert(JSONObject input) {
        GameSettings gameSettings = new GameSettings();
        gameSettings.seed = JSONUtils.toLong(input.get("seed"));
        gameSettings.gameName = (String)input.get("gameName");
        gameSettings.gameDifficulty = JSONUtils.toEnum(GameDifficulty.class, input.get("gameDifficulty"));
        if (input.has("timePlayed")) {
            gameSettings.timePlayed = new Timespan(JSONUtils.toLong(input.get("timePlayed")));
        }
        JSONArray dataPacks = (JSONArray)input.get("dataPackList");
        for (Object dataPack : dataPacks) {
            Map dataPackMap = (Map)dataPack;
            DataPackSettings dataPackSettings = new DataPackSettings();
            dataPackSettings.name = (String)dataPackMap.get("name");
            dataPackSettings.version = (String)dataPackMap.get("version");
            gameSettings.dataPackList.add(dataPackSettings);
        }
        return gameSettings;
    }

    @Override
    public JSONObject convertToJSON(GameSettings object) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("seed", object.seed);
        jsonObject.put("gameName", object.gameName);
        jsonObject.put("gameDifficulty", object.gameDifficulty.name());
        jsonObject.put("timePlayed", object.timePlayed.totalSeconds);
        ArrayList<JSONObject> datapacks = new ArrayList<JSONObject>();
        for (DataPackSettings dataPackSettings : object.dataPackList) {
            JSONObject dataPackJson = new JSONObject();
            dataPackJson.put("name", dataPackSettings.name);
            dataPackJson.put("version", dataPackSettings.version);
            datapacks.add(dataPackJson);
        }
        jsonObject.put("dataPackList", datapacks);
        return jsonObject;
    }
}

