/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.config.app;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.ApplicationSettings;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.JSONConverterBase;
import com.neutronio.astrax.io.json.config.app.JSONToGeneralSettings;
import com.neutronio.astrax.io.json.config.app.JSONToKeyMappingSettings;
import com.neutronio.astrax.io.json.config.app.JSONToSkinSettings;
import com.neutronio.astrax.io.json.config.app.JSONToVideoSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import java.util.Map;
import org.json.JSONObject;

public class JSONToApplicationSettings
extends JSONConverterBase<ApplicationSettings, String> {
    protected JSONToApplicationSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public JSONObject convertToJSON(ApplicationSettings object) {
        JSONToKeyMappingSettings keyMappingConverter = this.getLoader().getConverter(JSONToKeyMappingSettings.class);
        JSONToVideoSettings jsonToVideoSettings = this.getLoader().getConverter(JSONToVideoSettings.class);
        JSONToGeneralSettings jsonToGeneralSettings = this.getLoader().getConverter(JSONToGeneralSettings.class);
        JSONToSkinSettings jsonToSkinSettings = this.getLoader().getConverter(JSONToSkinSettings.class);
        JSONObject applicationJSON = new JSONObject();
        applicationJSON.put("generalSettings", jsonToGeneralSettings.convertToJSON(object.generalSettings));
        applicationJSON.put("activeUserProfileID", object.activeUserProfileID);
        JSONObject startupDatapackJson = new JSONObject();
        startupDatapackJson.put("path", object.startupDataPackPath);
        startupDatapackJson.put("location", (Object)object.startupDataPackLocation);
        applicationJSON.put("startupDatapack", startupDatapackJson);
        applicationJSON.put("videoSettings", jsonToVideoSettings.convertToJSON(object.videoSettings));
        applicationJSON.put("keyMappingSettings", keyMappingConverter.convertToJSON(object.keyMappingSettings));
        applicationJSON.put("skinSettings", jsonToSkinSettings.convertToJSON(object.skinSettings));
        return applicationJSON;
    }

    @Override
    public ApplicationSettings convert(String input) {
        JSONObject jsonConfig = new JSONObject(input);
        Map<String, Object> inputMap = jsonConfig.toMap();
        JSONToKeyMappingSettings keyMappingConverter = this.getLoader().getConverter(JSONToKeyMappingSettings.class);
        JSONToVideoSettings jsonToVideoSettings = this.getLoader().getConverter(JSONToVideoSettings.class);
        JSONToGeneralSettings jsonToGeneralSettings = this.getLoader().getConverter(JSONToGeneralSettings.class);
        JSONToSkinSettings jsonToSkinSettings = this.getLoader().getConverter(JSONToSkinSettings.class);
        ApplicationSettings applicationSettings = new ApplicationSettings();
        if (inputMap.containsKey("generalSettings")) {
            applicationSettings.generalSettings = jsonToGeneralSettings.convert((Map)inputMap.get("generalSettings"));
        }
        if (inputMap.containsKey("skinSettings")) {
            applicationSettings.skinSettings = jsonToSkinSettings.convert((Map)inputMap.get("skinSettings"));
        }
        if (inputMap.containsKey("activeUserProfileID")) {
            applicationSettings.activeUserProfileID = (String)inputMap.get("activeUserProfileID");
        }
        if (!inputMap.containsKey("startupDatapack")) {
            throw new AstraXException(AstraXException.ErrorCode.E2000, "Property 'startupDatapack' is missing!");
        }
        if (!inputMap.containsKey("videoSettings")) {
            throw new AstraXException(AstraXException.ErrorCode.E2000, "Property 'videoSettings' is missing!");
        }
        if (!inputMap.containsKey("keyMappingSettings")) {
            throw new AstraXException(AstraXException.ErrorCode.E2000, "Property 'keyMappingSettings' is missing!");
        }
        applicationSettings.videoSettings = jsonToVideoSettings.convert((Map)inputMap.get("videoSettings"));
        applicationSettings.keyMappingSettings = keyMappingConverter.convert((Map)inputMap.get("keyMappingSettings"));
        Map startupDatapack = (Map)inputMap.get("startupDatapack");
        String modpath = (String)startupDatapack.get("path");
        FileHandler.FileLocation location = FileHandler.FileLocation.valueOf((String)startupDatapack.get("location"));
        applicationSettings.startupDataPackPath = modpath;
        applicationSettings.startupDataPackLocation = location;
        return applicationSettings;
    }
}

