/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.config.app;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.app.datapack.DataPackSettings;
import com.neutronio.astrax.app.datapack.RepositoryLoaderSettings;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.JSONConverterBase;
import com.neutronio.astrax.io.json.config.JSONToSoundSettings;
import com.neutronio.astrax.io.json.config.app.JSONToKeyMappingSettings;
import com.neutronio.astrax.io.json.config.app.JSONToRepositoryLoaderSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.sfx.SoundSettings;
import java.util.Map;
import org.json.JSONObject;

public class JSONToDataPackSettings
extends JSONConverterBase<DataPackSettings, String> {
    protected JSONToDataPackSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public DataPackSettings convert(String inputString) {
        JSONObject jsonConfig = new JSONObject(inputString);
        Map<String, Object> input = jsonConfig.toMap();
        DataPackSettings settings = new DataPackSettings();
        if (input.containsKey("name")) {
            settings.name = (String)input.get("name");
        }
        if (input.containsKey("version")) {
            settings.version = (String)input.get("version");
        }
        if (input.containsKey("fileLocation")) {
            try {
                FileHandler.FileLocation fileLocation;
                settings.fileLocation = fileLocation = FileHandler.FileLocation.valueOf((String)input.get("fileLocation"));
            }
            catch (Exception e) {
                throw new AstraXException(AstraXException.ErrorCode.E3102, "FileLocation not found", e);
            }
        }
        if (input.containsKey("soundSettings")) {
            SoundSettings soundSettings;
            Map soundGroups = (Map)input.get("soundSettings");
            JSONToSoundSettings loadedConverter = this.getLoader().getConverter(JSONToSoundSettings.class);
            settings.soundSettings = soundSettings = loadedConverter.convert(soundGroups);
        }
        if (input.containsKey("repositorySettings")) {
            RepositoryLoaderSettings repositorySettings;
            JSONToRepositoryLoaderSettings repositoryLoaderConverter = this.getLoader().getConverter(JSONToRepositoryLoaderSettings.class);
            settings.repositoryLoaderSettings = repositorySettings = repositoryLoaderConverter.convert((Map)input.get("repositorySettings"));
        }
        if (input.containsKey("textureAtlas")) {
            settings.textureAtlas = (String)input.get("textureAtlas");
        }
        if (input.containsKey("keyMappings")) {
            Map keyMappings = (Map)input.get("keyMappings");
            JSONToKeyMappingSettings jsonToKeyMappingSettings = this.getLoader().getConverter(JSONToKeyMappingSettings.class);
            for (Map.Entry mappingEntry : keyMappings.entrySet()) {
                KeyMappingSettings satelliteKeyMappings = jsonToKeyMappingSettings.convert((Map)mappingEntry.getValue());
                settings.addKeyMappings((String)mappingEntry.getKey(), satelliteKeyMappings);
            }
        }
        return settings;
    }
}

