/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.config.app;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.input.DeviceType;
import com.neutronio.astrax.io.JSONConverterBase;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.util.JSONUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONObject;

public class JSONToKeyMappingSettings
extends JSONConverterBase<KeyMappingSettings, Map> {
    protected JSONToKeyMappingSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public JSONObject convertToJSON(KeyMappingSettings object) {
        JSONObject json = new JSONObject();
        for (KeyMappingSettings.KeyMapping mapping : object.getMappings()) {
            LinkedHashMap<String, Object> mappingValues = new LinkedHashMap<String, Object>();
            mappingValues.put("device", (Object)mapping.device);
            mappingValues.put("type", (Object)mapping.type);
            mappingValues.put("keycode", mapping.code);
            json.put(mapping.actionName, mappingValues);
        }
        return json;
    }

    @Override
    public KeyMappingSettings convert(Map input) {
        if (input == null || input.isEmpty()) {
            return new KeyMappingSettings();
        }
        KeyMappingSettings keyMappingSettings = new KeyMappingSettings();
        for (Object key : input.keySet()) {
            Map mapping = (Map)input.get(key);
            int keycode = JSONUtils.toInteger(mapping.get("keycode"));
            KeyMappingSettings.InputType inputType = null;
            DeviceType deviceType = null;
            String typeString = (String)mapping.get("type");
            try {
                inputType = KeyMappingSettings.InputType.valueOf(typeString);
            }
            catch (Exception e) {
                throw new AstraXException(AstraXException.ErrorCode.E3000, (Throwable)e);
            }
            String deviceString = (String)mapping.get("device");
            try {
                deviceType = DeviceType.valueOf(deviceString);
            }
            catch (Exception e) {
                throw new AstraXException(AstraXException.ErrorCode.E3000, (Throwable)e);
            }
            keyMappingSettings.addMapping(deviceType, inputType, keycode, (String)key);
        }
        return keyMappingSettings;
    }
}

