/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.config.app;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.FactorySettings;
import com.neutronio.astrax.app.datapack.RepositoryLoaderSettings;
import com.neutronio.astrax.app.datapack.TranslationSettings;
import com.neutronio.astrax.io.JSONConverterBase;
import com.neutronio.astrax.io.json.game.DataManager;
import java.util.List;
import java.util.Map;

public class JSONToRepositoryLoaderSettings
extends JSONConverterBase<RepositoryLoaderSettings, Map> {
    protected JSONToRepositoryLoaderSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public RepositoryLoaderSettings convert(Map input) {
        RepositoryLoaderSettings repositoryLoaderSettings = new RepositoryLoaderSettings();
        if (input.containsKey("translations")) {
            Map translationsMap = (Map)input.get("translations");
            for (Object translationsKey : translationsMap.keySet()) {
                Map bundleMap = (Map)translationsMap.get(translationsKey);
                TranslationSettings translationSettings = new TranslationSettings();
                translationSettings.bundleName = (String)bundleMap.get("bundleName");
                translationSettings.path = (String)bundleMap.get("path");
                repositoryLoaderSettings.putTranslations(translationSettings);
            }
        }
        if (input.containsKey("factories")) {
            List factorySettingsJSON = (List)input.get("factories");
            for (Map factorySettingJSON : factorySettingsJSON) {
                Class<?> factoryClass = null;
                String className = (String)factorySettingJSON.get("class");
                List nameSets = (List)factorySettingJSON.get("nameSets");
                String nameGenerator = null;
                if (factorySettingJSON.containsKey("nameGenerator")) {
                    nameGenerator = (String)factorySettingJSON.get("nameGenerator");
                }
                try {
                    factoryClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new AstraXException(AstraXException.ErrorCode.E2004, "Factory class '" + className + "'", e);
                }
                repositoryLoaderSettings.addFactorySetting(new FactorySettings.FactorySetting(factoryClass, nameSets, nameGenerator));
            }
        }
        if (input.containsKey("converters")) {
            List converters = (List)input.get("converters");
            for (String converterName : converters) {
                Class<?> converterClass = null;
                try {
                    converterClass = Class.forName(converterName);
                }
                catch (ClassNotFoundException e) {
                    throw new AstraXException(AstraXException.ErrorCode.E2004, "JSONConverter '" + converterName + "'. Is the converter spelled correctly and situated in the right package?", e);
                }
                repositoryLoaderSettings.addConverter(converterClass);
            }
        }
        List repositories = (List)input.get("repositories");
        for (Map repositorySetting : repositories) {
            String repoPath = (String)repositorySetting.get("path");
            String repoClassName = (String)repositorySetting.get("class");
            String repoConverterClassName = (String)repositorySetting.get("converter");
            Class<?> repoClass = null;
            Class<?> repoConverterClass = null;
            try {
                repoClass = Class.forName(repoClassName);
            }
            catch (ClassNotFoundException e) {
                throw new AstraXException(AstraXException.ErrorCode.E2004, "Repository '" + repoClassName + "'", e);
            }
            try {
                repoConverterClass = Class.forName(repoConverterClassName);
            }
            catch (ClassNotFoundException e) {
                throw new AstraXException(AstraXException.ErrorCode.E2004, "Repository '" + repoConverterClassName + "'", e);
            }
            repositoryLoaderSettings.addRepository(repoPath, repoClass, repoConverterClass);
        }
        return repositoryLoaderSettings;
    }
}

