/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.config.app;

import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.io.JSONConverterBase;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.util.JSONUtils;
import com.neutronio.astrax.util.date.Timespan;
import java.util.Date;
import java.util.Map;
import org.json.JSONObject;

public class JSONToSavedGame
extends JSONConverterBase<SavedGame, Map> {
    public JSONToSavedGame(DataManager loader) {
        super(loader);
    }

    @Override
    public SavedGame convert(Map input) {
        SavedGame savedGame = new SavedGame();
        savedGame.gameName = (String)input.get("gameName");
        savedGame.currentGalaxyName = (String)input.get("currentGalaxyName");
        savedGame.lastPlayed = new Date(JSONUtils.toLong(input.get("lastPlayed")));
        if (input.containsKey("playTime")) {
            savedGame.playTime = new Timespan(JSONUtils.toLong(input.get("playTime")));
        }
        savedGame.chipcoin = JSONUtils.toInteger(input.get("chipcoin"));
        savedGame.discoveryPoints = JSONUtils.toInteger(input.get("discoveryPoints"));
        return savedGame;
    }

    @Override
    public JSONObject convertToJSON(SavedGame object) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("gameName", object.gameName);
        jsonObject.put("currentGalaxyName", object.currentGalaxyName);
        jsonObject.put("lastPlayed", object.lastPlayed.getTime());
        jsonObject.put("playTime", object.playTime.totalSeconds);
        jsonObject.put("chipcoin", object.chipcoin);
        jsonObject.put("discoveryPoints", object.discoveryPoints);
        return jsonObject;
    }
}

