/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.config.app;

import com.neutronio.astrax.app.SkinSettings;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.JSONConverterBase;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.util.JSONUtils;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

public class JSONToSkinSettings
extends JSONConverterBase<SkinSettings, Map> {
    public JSONToSkinSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public JSONObject convertToJSON(SkinSettings object) {
        JSONObject audioJSON = new JSONObject();
        audioJSON.put("language", object.language.toLanguageTag());
        audioJSON.put("baseDirectory", object.baseDirectory);
        audioJSON.put("skinLocation", object.skinLocation.name());
        audioJSON.put("soundsFile", object.soundsFile);
        audioJSON.put("stylesJsonFile", object.stylesJsonFile);
        audioJSON.put("stylesAtlasFile", object.stylesAtlasFile);
        audioJSON.put("translationsPath", object.translationsPath);
        audioJSON.put("translationsBundleName", object.translationsBundleName);
        audioJSON.put("uiColors", JSONUtils.toJSONObject(object.uiColors));
        return audioJSON;
    }

    @Override
    public SkinSettings convert(Map input) {
        SkinSettings skinSettings = new SkinSettings();
        skinSettings.language = Locale.forLanguageTag((String)input.get("language"));
        skinSettings.baseDirectory = (String)input.get("baseDirectory");
        skinSettings.skinLocation = JSONUtils.toEnum(FileHandler.FileLocation.class, input.get("skinLocation"));
        skinSettings.soundsFile = (String)input.get("soundsFile");
        skinSettings.stylesJsonFile = (String)input.get("stylesJsonFile");
        skinSettings.stylesAtlasFile = (String)input.get("stylesAtlasFile");
        skinSettings.translationsPath = (String)input.get("translationsPath");
        skinSettings.translationsBundleName = (String)input.get("translationsBundleName");
        skinSettings.uiColors = JSONUtils.toColorPalette(input.get("uiColors"));
        return skinSettings;
    }
}

