/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.config.app;

import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.io.JSONConverterBase;
import com.neutronio.astrax.io.json.config.app.JSONToKeyMappingSettings;
import com.neutronio.astrax.io.json.config.app.JSONToSavedGame;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.util.JSONUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONToUserProfile
extends JSONConverterBase<UserProfile, Map> {
    JSONToKeyMappingSettings jsonToKeyMappingSettings = this.getLoader().getConverter(JSONToKeyMappingSettings.class);
    JSONToSavedGame jsonToSavedGame = this.getLoader().getConverter(JSONToSavedGame.class);

    protected JSONToUserProfile(DataManager loader) {
        super(loader);
    }

    @Override
    public JSONObject convertToJSON(UserProfile object) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("uuid", object.id);
        values.put("playerName", object.playerName);
        values.put("resourcePath", object.resourcePath);
        values.put("avatarTextureIndices", JSONUtils.toJSONArray(object.avatarTextureIndices));
        values.put("avatarColorIndices", JSONUtils.toJSONArray(object.avatarColorIndices));
        if (object.keyMappings != null) {
            values.put("keyMappings", this.jsonToKeyMappingSettings.convertToJSON(object.keyMappings));
        }
        if (object.savedGames != null && !object.savedGames.isEmpty()) {
            JSONArray savedGamesJson = new JSONArray();
            for (SavedGame savedGame : object.savedGames) {
                savedGamesJson.put(this.jsonToSavedGame.convertToJSON(savedGame));
            }
            values.put("savedGames", savedGamesJson);
        }
        return new JSONObject(values);
    }

    @Override
    public UserProfile convert(Map input) {
        UserProfile profile = new UserProfile();
        profile.id = (String)input.get("uuid");
        profile.playerName = (String)input.get("playerName");
        profile.resourcePath = (String)input.get("resourcePath");
        if (input.containsKey("avatarTextureIndices")) {
            profile.avatarTextureIndices = JSONUtils.toIntegerArray((List)input.get("avatarTextureIndices"));
        }
        if (input.containsKey("avatarColorIndices")) {
            profile.avatarColorIndices = JSONUtils.toIntegerArray((List)input.get("avatarColorIndices"));
        }
        if (input.containsKey("savedGames")) {
            List savedGamesJson = (List)input.get("savedGames");
            for (Object savedGameMap : savedGamesJson) {
                profile.savedGames.add(this.jsonToSavedGame.convert((Map)savedGameMap));
            }
        }
        return profile;
    }
}

