/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.AbstractApplicationFactory;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.Factory;
import com.neutronio.astrax.app.datapack.DataRepositorySetting;
import com.neutronio.astrax.app.datapack.FactorySettings;
import com.neutronio.astrax.app.datapack.RepositoryLoaderSettings;
import com.neutronio.astrax.app.datapack.TranslationSettings;
import com.neutronio.astrax.app.datapack.UsageStatistics;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.app.repository.DataRepository;
import com.neutronio.astrax.app.repository.Tagged;
import com.neutronio.astrax.app.repository.TaggedRepository;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.json.JSONConverter;
import com.neutronio.astrax.io.json.config.JSONSettingSource;
import com.neutronio.astrax.io.json.game.JSONDataSource;
import com.neutronio.astrax.lang.I18n;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataManager
implements DataContext {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Map<Class, DataRepository> loadedRepositories = new LinkedHashMap<Class, DataRepository>();
    protected Map<Class, JSONConverter> loadedConverters = new LinkedHashMap<Class, JSONConverter>();
    protected Map<Class, Factory> loadedFactories = new LinkedHashMap<Class, Factory>();
    @Deprecated
    protected Map<Class, AbstractApplicationFactory> loadedApplicationFactories = new LinkedHashMap<Class, AbstractApplicationFactory>();
    protected List<RepositoryLoaderSettings> loadedSettings = new ArrayList<RepositoryLoaderSettings>();
    protected Map<String, I18n> translations = new LinkedHashMap<String, I18n>();

    public void loadTranslations(TranslationSettings translationSettings, FileHandler.FileLocation location, String modRoot, Locale locale) {
        this.logger.finest("Loading Translations...");
        if (this.translations.containsKey(translationSettings.bundleName)) {
            this.logger.warning("Translation Bundle of name " + translationSettings.bundleName + " already exists!");
            return;
        }
        I18n translations = new I18n(locale);
        translations.loadBundles(modRoot + "/" + translationSettings.path, location, translationSettings.bundleName);
        this.translations.put(translationSettings.bundleName, translations);
    }

    public String translate(String key) {
        return this.translations.get("astrax-data").translate(key);
    }

    public String translate(String bundleName, String key) {
        return this.translations.get(bundleName).translate(key);
    }

    public String translateMarked(String key) {
        if (key.startsWith("$")) {
            return this.translations.get("astrax-data").translate(key.substring(1));
        }
        return key;
    }

    public String translateMarked(String bundleName, String key) {
        if (key.startsWith("$")) {
            if (!this.translations.containsKey(bundleName)) {
                return key;
            }
            return this.translations.get(bundleName).translate(key.substring(1));
        }
        return key;
    }

    @Override
    public <T> List<T> findDataByIDs(List<String> ids) {
        ArrayList result = new ArrayList();
        for (DataRepository repository : this.loadedRepositories.values()) {
            for (String id : ids) {
                if (!repository.contains(id)) continue;
                result.add(repository.find(id));
            }
        }
        return result;
    }

    @Override
    public <T> T findDataByID(String id) {
        for (DataRepository repository : this.loadedRepositories.values()) {
            if (!repository.contains(id)) continue;
            return (T)repository.find(id);
        }
        return null;
    }

    @Override
    public List<Tagged> findDataByTags(List<String> tags) {
        ArrayList<Tagged> objects = new ArrayList<Tagged>();
        for (DataRepository repository : this.loadedRepositories.values()) {
            if (!(repository instanceof TaggedRepository)) continue;
            objects.addAll(((TaggedRepository)repository).findByTags(tags, false));
        }
        return objects;
    }

    @Override
    public List<Tagged> findDataByTags(List<String> tags, List<String> blacklist) {
        ArrayList<Tagged> objects = new ArrayList<Tagged>();
        for (DataRepository repository : this.loadedRepositories.values()) {
            if (!(repository instanceof TaggedRepository)) continue;
            objects.addAll(((TaggedRepository)repository).findByTags(tags, blacklist));
        }
        return objects;
    }

    public void addConfiguration(RepositoryLoaderSettings loaderSettings) {
        this.loadedSettings.add(loaderSettings);
    }

    public DataRepositorySetting findRepositorySettingOf(Class<DataRepository> clazz) {
        for (RepositoryLoaderSettings setting : this.loadedSettings) {
            DataRepositorySetting repositorySetting = setting.findRepositorySettingOf(clazz);
            if (repositorySetting == null) continue;
            return repositorySetting;
        }
        return null;
    }

    public void instantiateFactoriesAndConverters(RepositoryLoaderSettings loaderSettings) {
        this.instantiateConverters(loaderSettings);
        this.instantiateFactories(loaderSettings);
    }

    public void instantiateConverters(RepositoryLoaderSettings loaderSettings) {
        int i2;
        if (loaderSettings.getConverterCount() == 0) {
            this.logger.log(Level.WARNING, "No Converters available for this Loader! Is this intentional?");
        }
        for (i2 = 0; i2 < loaderSettings.getConverterCount(); ++i2) {
            this.newConverterInstance(loaderSettings.getConverter(i2));
        }
        this.logger.log(Level.WARNING, "Instantiated " + i2 + " converters. ");
    }

    public void instantiateFactories(RepositoryLoaderSettings loaderSettings) {
        if (loaderSettings.getFacxtorySettings().isEmpty()) {
            this.logger.log(Level.WARNING, "No Factories available for this DataPack! Is this intentional?");
        }
        int i2 = 0;
        for (FactorySettings.FactorySetting factorySetting : loaderSettings.getFacxtorySettings()) {
            try {
                this.logger.finest("... Instantiating " + factorySetting.factoryClass.getCanonicalName());
                Constructor<? extends Factory> constructor = factorySetting.factoryClass.getConstructor(DataContext.class);
                AbstractFactory factory = (AbstractFactory)constructor.newInstance(this);
                factory.setSettings(factorySetting);
                this.loadedFactories.put(factory.getClass(), factory);
                ++i2;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new AstraXException(AstraXException.ErrorCode.E2003, "No suitable constructor found in factory class.\nIs constructor public? Does it have a single parameter of type DataPack?", e);
            }
        }
        this.logger.log(Level.WARNING, "Instantiated " + i2 + " factories. ");
    }

    public Map<Class, Factory> getLoadedFactories() {
        return this.loadedFactories;
    }

    public Map<Class, DataRepository> getLoadedRepositories() {
        return this.loadedRepositories;
    }

    public Map<Class, JSONConverter> getLoadedConverters() {
        return this.loadedConverters;
    }

    @Override
    public <T extends JSONConverter> T getConverter(Class<T> clazz) {
        return (T)this.loadedConverters.get(clazz);
    }

    @Override
    public <T extends DataRepository> T getRepository(Class<T> clazz) {
        return (T)this.loadedRepositories.get(clazz);
    }

    @Override
    public <T extends Factory> T getFactory(Class<T> clazz) {
        return (T)this.loadedFactories.get(clazz);
    }

    public <T extends Factory> T getLoadedAppFactory(Class<T> clazz) {
        return (T)this.loadedApplicationFactories.get(clazz);
    }

    public Collection<Factory> getAllLoadedFactories() {
        return this.loadedFactories.values();
    }

    public void registerDataRepository(DataRepository repository, DataRepositorySetting setting) {
        this.logger.log(Level.FINEST, "Registering Data Repository " + repository.getClass().getCanonicalName());
        this.loadedRepositories.put(repository.getClass(), repository);
    }

    @Override
    public void registerConverter(JSONConverter converter) {
    }

    @Override
    public void registerRepository(DataRepository repository) {
    }

    @Override
    public void registerFactory(Factory factory) {
        this.logger.log(Level.FINEST, "Registering Factory " + factory.getClass().getCanonicalName());
        this.loadedFactories.put(factory.getClass(), factory);
    }

    @Override
    public void unregisterConverter(JSONConverter converter) {
    }

    @Override
    public void unregisterRepository(DataRepository repository) {
    }

    @Override
    public void unregisterFactory(AbstractFactory factory) {
    }

    public Factory getFactoryByNameSpace(NameSpace nameSpace) {
        for (Factory factory : this.loadedFactories.values()) {
            if (!(factory instanceof AbstractFactory) || !Objects.equals(((AbstractFactory)factory).getNamespace(), nameSpace.getObject())) continue;
            return factory;
        }
        return null;
    }

    @Deprecated
    public <T extends DataRepository> T loadRepository(Class<T> dataRepository, String fileTextContent) {
        JSONDataSource annotation = dataRepository.getAnnotation(JSONDataSource.class);
        if (annotation == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0002, "Annotation " + JSONDataSource.class.getCanonicalName() + " expected in class " + dataRepository.getCanonicalName() + ". Please define Annotation and JSONConverter, then retry!");
        }
        Class<? extends JSONConverter> jsonConverterClass = annotation.value();
        JSONConverter converter = this.loadedConverters.get(jsonConverterClass);
        DataRepository repository = (DataRepository)converter.convert(fileTextContent);
        this.registerDataRepository(repository, null);
        return (T)repository;
    }

    public <T> T load(Class<T> settingsObject, String fileTextContent) {
        JSONSettingSource annotation = settingsObject.getAnnotation(JSONSettingSource.class);
        if (annotation == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0002, "Annotation " + JSONSettingSource.class.getCanonicalName() + " expected in class " + settingsObject.getCanonicalName() + ". Please define Annotation and JSONConverter, then retry!");
        }
        Class<? extends JSONConverter> jsonConverterClass = annotation.value();
        JSONConverter converter = this.loadedConverters.get(jsonConverterClass);
        if (converter == null) {
            throw new AstraXException(AstraXException.ErrorCode.E2004, "Missing converter: " + jsonConverterClass + ". Did something go wrong?");
        }
        Object settings = converter.convert(fileTextContent);
        return settings;
    }

    public <T extends JSONConverter> T newConverterInstance(Class<T> clazz) {
        this.logger.log(Level.FINEST, "Instantiating Converter of type " + clazz.getCanonicalName());
        JSONConverter newInstance = null;
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(this.getClass());
            boolean accessible = constructor.isAccessible();
            constructor.setAccessible(true);
            newInstance = (JSONConverter)constructor.newInstance(this);
            constructor.setAccessible(accessible);
        }
        catch (InstantiationException e) {
            throw new AstraXException(AstraXException.ErrorCode.E2003, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AstraXException(AstraXException.ErrorCode.E2003, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new AstraXException(AstraXException.ErrorCode.E2003, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new AstraXException(AstraXException.ErrorCode.E2003, (Throwable)e);
        }
        if (newInstance == null) {
            throw new AstraXException(AstraXException.ErrorCode.E2003, "Unable to instantiate '" + clazz.getCanonicalName() + "'");
        }
        this.loadedConverters.put(clazz, newInstance);
        return (T)newInstance;
    }

    public UsageStatistics getStatistics() {
        UsageStatistics statistics = new UsageStatistics();
        statistics.unusedIDs = new ArrayList<String>();
        float usageSum = 0.0f;
        for (DataRepository repository : this.loadedRepositories.values()) {
            usageSum += repository.getUsage();
            statistics.unusedIDs.addAll(repository.getUnusedObjectIDs());
        }
        statistics.usedIDsObjectsFactor = usageSum / (float)this.loadedRepositories.size();
        return statistics;
    }
}

