/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteRole;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.VesselSize;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.util.JSONUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONToSatelliteGrid
extends GameDataJSONConverter<SatelliteGrid, Map> {
    public JSONToSatelliteGrid(DataManager loader) {
        super(loader);
    }

    @Override
    public SatelliteGrid convert(Map input) {
        ModuleSettingsRepository moduleSettingsRepository = this.getLoader().getRepository(ModuleSettingsRepository.class);
        VesselSize vesselSize = JSONUtils.toEnum(VesselSize.class, input.get("vesselSize"));
        SatelliteRole vesselRole = JSONUtils.toEnum(SatelliteRole.class, input.get("vesselRole"));
        SatelliteGrid satelliteGrid = new SatelliteGrid(vesselRole, vesselSize);
        satelliteGrid.name = (String)input.get("name");
        satelliteGrid.hullpoints = JSONUtils.toInteger(input.get("hullpoints"));
        satelliteGrid.weight = JSONUtils.toFloat(input.get("weight"));
        satelliteGrid.value = JSONUtils.toFloat(input.get("value"));
        List data = (List)input.get("data");
        for (Object dataObject : data) {
            Map moduleMap = (Map)dataObject;
            String moduleID = (String)moduleMap.get("id");
            ModuleSettings moduleSettings = (ModuleSettings)moduleSettingsRepository.find(moduleID);
            int x = JSONUtils.toInteger(moduleMap.get("x"));
            int y = JSONUtils.toInteger(moduleMap.get("y"));
            Orientation orientation = Orientation.valueOf((String)moduleMap.get("orientation"));
            Color color = Color.WHITE;
            if (moduleMap.containsKey("color")) {
                String colorObject = (String)moduleMap.get("color");
                colorObject = colorObject.replace('#', ' ');
                colorObject = colorObject.trim();
                this.logger.log(Level.FINEST, "Decoding color value '" + colorObject + "'");
                if (colorObject.isEmpty()) {
                    this.logger.log(Level.SEVERE, "Could not parse color of value '" + colorObject + "'");
                } else {
                    try {
                        color = Color.valueOf(colorObject);
                    }
                    catch (NumberFormatException ex) {
                        this.logger.log(Level.SEVERE, "Could not parse color of value '" + colorObject + "' " + ex.getMessage());
                    }
                }
            }
            satelliteGrid.placeData(x, y, new SatelliteGrid.SatelliteGridSettings(moduleSettings, orientation, color));
        }
        return satelliteGrid;
    }

    @Override
    public JSONObject convertToJSON(SatelliteGrid object) {
        JSONObject output = new JSONObject();
        output.put("name", object.name);
        output.put("vesselSize", (Object)object.vesselSize);
        output.put("vesselRole", (Object)object.vesselRole);
        output.put("hullpoints", object.hullpoints);
        output.put("weight", object.weight);
        output.put("value", object.value);
        JSONArray dataArray = new JSONArray();
        for (int x = 0; x < object.getData().getWidth(); ++x) {
            for (int y = 0; y < object.getData().getHeight(); ++y) {
                SatelliteGrid.SatelliteGridSettings module = object.getData().get(x, y);
                if (module == null) continue;
                JSONObject moduleData = new JSONObject();
                moduleData.put("id", module.moduleSettings.id);
                moduleData.put("x", x);
                moduleData.put("y", y);
                moduleData.put("orientation", (Object)module.orientation);
                moduleData.put("color", module.tint.toString());
                dataArray.put(moduleData);
            }
        }
        output.put("data", dataArray);
        return output;
    }
}

