/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game;

import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.util.Tech;
import com.neutronio.astrax.util.TechTree;
import com.neutronio.astrax.util.collections.MultiLinkedList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONToTechTree
extends GameDataJSONConverter<TechTree, Map> {
    protected JSONToTechTree(DataManager loader) {
        super(loader);
    }

    @Override
    public JSONObject convert(TechTree techTree) {
        boolean layerHasChildren = false;
        int currentDepth = 0;
        JSONObject jsonTechTree = new JSONObject();
        do {
            List childrenOfDepth;
            layerHasChildren = (childrenOfDepth = techTree.getChildrenOfDepth(currentDepth)).size() > 0;
            for (MultiLinkedList.Node<Tech> node : childrenOfDepth) {
                JSONObject object = this.convertNode(node);
                jsonTechTree.put(node.getValue().getUserObject().toString(), object);
            }
            ++currentDepth;
        } while (layerHasChildren);
        return jsonTechTree;
    }

    private JSONObject convertNode(MultiLinkedList.Node<Tech> techNode) {
        JSONObject jsonNode = new JSONObject();
        JSONArray childrenArray = new JSONArray();
        for (int i2 = 0; i2 < techNode.getChildrenCount(); ++i2) {
            MultiLinkedList.Node<Tech> childAt = techNode.getChildAt(i2);
            childrenArray.put(i2, childAt.getValue().getUserObject());
        }
        JSONObject jsonTech = new JSONObject();
        jsonTech.put("probability", techNode.getValue().getProbability());
        jsonTech.put("maxChildren", techNode.getValue().getMaxChildren());
        jsonNode.put("value", jsonTech);
        jsonNode.put("children", childrenArray);
        return jsonNode;
    }

    @Override
    public TechTree convert(Map objectMap) {
        TechTree tree = new TechTree();
        Map<String, MultiLinkedList.Node<Tech>> techs = this.createTechs(objectMap);
        Map<String, List<String>> relationships = this.buildRelationships(objectMap);
        this.buildTree(tree, techs, relationships);
        return tree;
    }

    private Map<String, MultiLinkedList.Node<Tech>> createTechs(Map<String, Object> objectMap) {
        LinkedHashMap<String, MultiLinkedList.Node<Tech>> techs = new LinkedHashMap<String, MultiLinkedList.Node<Tech>>();
        for (String key : objectMap.keySet()) {
            Map treeNode = (Map)objectMap.get(key);
            Map techMap = (Map)treeNode.get("value");
            Tech<String> tech = new Tech<String>();
            if (techMap.containsKey("maxChildren")) {
                tech.withChildren(((Number)techMap.get("maxChildren")).intValue());
            }
            if (!techMap.containsKey("probability")) {
                throw new NullPointerException("Probability must be always defined!");
            }
            tech.withProbability(((Number)techMap.get("probability")).floatValue());
            tech.withUserObject(key);
            techs.put(key, MultiLinkedList.getNode(tech));
        }
        return techs;
    }

    private Map<String, List<String>> buildRelationships(Map<String, Object> objectMap) {
        HashMap<String, List<String>> relationships = new HashMap<String, List<String>>();
        for (String key : objectMap.keySet()) {
            Map treeNode = (Map)objectMap.get(key);
            if (!treeNode.containsKey("children")) continue;
            relationships.put(key, (List)treeNode.get("children"));
        }
        return relationships;
    }

    private void buildTree(TechTree dest, Map<String, MultiLinkedList.Node<Tech>> techs, Map<String, List<String>> relationships) {
        MultiLinkedList.Node<Tech> node;
        for (String key : techs.keySet()) {
            node = techs.get(key);
            List<String> childrenRefs = relationships.get((String)node.getValue().getUserObject());
            if (childrenRefs == null) continue;
            for (String ref : childrenRefs) {
                MultiLinkedList.Node<Tech> child = techs.get(ref);
                if (child != null) {
                    node.addChild(child);
                    continue;
                }
                this.logger.warning("Could not find child: " + ref);
            }
        }
        for (String key : techs.keySet()) {
            node = techs.get(key);
            if (node.getParentCount() != 0) continue;
            this.logger.info("Root set as: " + key);
            dest.setRoot(node);
            break;
        }
    }
}

