/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockerSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.VesselSize;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.DrillSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.TankSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.ThrusterSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.quarters.QuarterSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.CockpitSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.MarketSettings;
import com.neutronio.astrax.editor.placement.Connector;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import com.neutronio.astrax.io.json.game.JSONToProbabilitySet;
import com.neutronio.astrax.util.JSONUtils;
import java.util.List;
import java.util.Map;

public class JSONToModuleSettings
extends GameDataJSONConverter<ModuleSettings, Map> {
    public JSONToModuleSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public ModuleSettings convert(Map input) {
        ModuleSettings moduleSettings = new ModuleSettings();
        if (!input.containsKey("name")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "name");
        }
        if (!input.containsKey("textureRegion")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "textureRegion");
        }
        if (!input.containsKey("editorIcon")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "editorIcon");
        }
        if (!input.containsKey("description")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "description");
        }
        if (!input.containsKey("hullpoints")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "hullpoints");
        }
        if (!input.containsKey("weight")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "weight");
        }
        if (!input.containsKey("value")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "value");
        }
        if (!input.containsKey("connector")) {
            throw new AstraXException(AstraXException.ErrorCode.E2005, "connector");
        }
        moduleSettings.id = (String)input.get("id");
        moduleSettings.name = (String)input.get("name");
        moduleSettings.textureRegion = (String)input.get("textureRegion");
        moduleSettings.editorIcon = (String)input.get("editorIcon");
        moduleSettings.description = (String)input.get("description");
        moduleSettings.hullpoints = JSONUtils.toInteger(input.get("hullpoints"));
        moduleSettings.weight = JSONUtils.toFloat(input.get("weight"));
        moduleSettings.value = JSONUtils.toFloat(input.get("value"));
        moduleSettings.color = JSONUtils.toColor(input.get("color"));
        List connectorList = (List)input.get("connector");
        moduleSettings.connector = new Connector((Boolean)connectorList.get(0), (Boolean)connectorList.get(1), (Boolean)connectorList.get(2), (Boolean)connectorList.get(3));
        if (input.containsKey("cargoSettings")) {
            moduleSettings.cargoSettings = this.toCargoSettings((Map)input.get("cargoSettings"));
        }
        if (input.containsKey("cockpitSettings")) {
            moduleSettings.cockpitSettings = this.toCockpitSettings((Map)input.get("cockpitSettings"));
        }
        if (input.containsKey("dockerSettings")) {
            moduleSettings.dockerSettings = this.toDockerSettings((Map)input.get("dockerSettings"));
        }
        if (input.containsKey("drillSettings")) {
            moduleSettings.drillSettings = this.toDrillSettings((Map)input.get("drillSettings"));
        }
        if (input.containsKey("energySettings")) {
            moduleSettings.energySettings = this.toTankSettings((Map)input.get("energySettings"));
        }
        if (input.containsKey("quarterSettings")) {
            moduleSettings.quarterSettings = this.toQuarterSettings((Map)input.get("quarterSettings"));
        }
        if (input.containsKey("tankSettings")) {
            moduleSettings.tankSettings = this.toTankSettings((Map)input.get("tankSettings"));
        }
        if (input.containsKey("thrusterSettings")) {
            moduleSettings.thrusterSettings = this.toThrusterSettings((Map)input.get("thrusterSettings"));
        }
        if (input.containsKey("marketSettings")) {
            moduleSettings.marketSettings = this.toMarketSettings((Map)input.get("marketSettings"));
        }
        return moduleSettings;
    }

    public CargoSettings toCargoSettings(Map map) {
        CargoSettings cargoSettings = new CargoSettings();
        cargoSettings.maxWeight = JSONUtils.toFloat(map.get("maxWeight"));
        return cargoSettings;
    }

    public CockpitSettings toCockpitSettings(Map map) {
        CockpitSettings cockpitSettings = new CockpitSettings();
        cockpitSettings.cockpitSeats = JSONUtils.toInteger(map.get("cockpitSeats"));
        cockpitSettings.sensorRange = JSONUtils.toFloat(map.get("sensorRange"));
        cockpitSettings.amountInstantTargets = JSONUtils.toInteger(map.get("amountInstantTargets"));
        return cockpitSettings;
    }

    public DockerSettings toDockerSettings(Map map) {
        DockerSettings dockerSettings = new DockerSettings();
        dockerSettings.offsetX = JSONUtils.toInteger(map.get("offsetX"));
        dockerSettings.offsetY = JSONUtils.toInteger(map.get("offsetY"));
        List vesselSizeList = (List)map.get("allowedVesselSizes");
        dockerSettings.allowedVesselSizes = new VesselSize[vesselSizeList.size()];
        int i2 = 0;
        for (Object vesselSize : vesselSizeList) {
            dockerSettings.allowedVesselSizes[i2] = JSONUtils.toEnum(VesselSize.class, vesselSize);
            ++i2;
        }
        return dockerSettings;
    }

    public MarketSettings toMarketSettings(Map map) {
        JSONToProbabilitySet converter = this.getLoader().getConverter(JSONToProbabilitySet.class);
        MarketSettings marketSettings = new MarketSettings();
        marketSettings.possibleTraders = converter.convert((Map)map.get("possibleTraders"));
        return marketSettings;
    }

    public DrillSettings toDrillSettings(Map map) {
        DrillSettings drillSettings = new DrillSettings();
        drillSettings.hitpoints = JSONUtils.toFloat(map.get("hitpoints"));
        drillSettings.gatheringInterval = JSONUtils.toFloat(map.get("gatheringInterval"));
        drillSettings.gatheringYield = JSONUtils.toFloat(map.get("gatheringYield"));
        drillSettings.drillSound = (String)map.get("drillSound");
        drillSettings.fuelType = (String)map.get("fuelType");
        drillSettings.fuelConsumption = JSONUtils.toFloat(map.get("fuelConsumption"));
        return drillSettings;
    }

    public QuarterSettings toQuarterSettings(Map map) {
        QuarterSettings quarterSettings = new QuarterSettings();
        quarterSettings.beds = JSONUtils.toInteger(map.get("beds"));
        quarterSettings.comfort = JSONUtils.toFloat(map.get("comfort"));
        return quarterSettings;
    }

    public TankSettings toTankSettings(Map map) {
        TankSettings tankSettings = new TankSettings();
        tankSettings.fuelType = (String)map.get("fuelType");
        if (map.containsKey("capacity")) {
            tankSettings.capacity = JSONUtils.toFloat(map.get("capacity"));
        }
        if (map.containsKey("production")) {
            tankSettings.production = JSONUtils.toFloat(map.get("production"));
        }
        if (map.containsKey("consumption")) {
            tankSettings.consumption = JSONUtils.toFloat(map.get("consumption"));
        }
        return tankSettings;
    }

    public ThrusterSettings toThrusterSettings(Map map) {
        ThrusterSettings thrusterSettings = new ThrusterSettings();
        thrusterSettings.particleEmitter = (String)map.get("particleEmitter");
        thrusterSettings.fuelType = (String)map.get("fuelType");
        thrusterSettings.engineSound = (String)map.get("engineSound");
        thrusterSettings.startupSound = (String)map.get("startupSound");
        thrusterSettings.maxThrust = JSONUtils.toFloat(map.get("maxThrust"));
        thrusterSettings.deltaThrust = JSONUtils.toFloat(map.get("deltaThrust"));
        thrusterSettings.operationMode = JSONUtils.toEnum(ThrusterSettings.OperationMode.class, map.get("operationMode"));
        thrusterSettings.fuelConsumption = JSONUtils.toFloat(map.get("fuelConsumption"));
        thrusterSettings.fuelIdleConsumption = JSONUtils.toFloat(map.get("fuelIdleConsumption"));
        return thrusterSettings;
    }
}

