/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.io.json.game.generator;

import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitSettings;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.GameDataJSONConverter;
import java.util.Map;

public class JSONToOrbitSettings
extends GameDataJSONConverter<OrbitSettings, Map> {
    protected JSONToOrbitSettings(DataManager loader) {
        super(loader);
    }

    @Override
    public OrbitSettings convert(Map input) {
        OrbitSettings.OrbitType orbitType;
        OrbitSettings orbitSettings = new OrbitSettings();
        orbitSettings.orbitType = orbitType = OrbitSettings.OrbitType.valueOf((String)input.get("orbitType"));
        if (input.containsKey("circleFactor")) {
            float circleFactor = ((Number)input.get("circleFactor")).floatValue();
            orbitSettings.circleFactor = MathUtils.clamp(circleFactor, 0.0f, 1.0f);
        }
        if (input.containsKey("offsetX")) {
            orbitSettings.offsetX = ((Number)input.get("offsetX")).floatValue();
        }
        if (input.containsKey("offsetY")) {
            orbitSettings.offsetY = ((Number)input.get("offsetY")).floatValue();
        }
        if (input.containsKey("maxVelocity")) {
            orbitSettings.maxVelocity = ((Number)input.get("maxVelocity")).floatValue();
        }
        if (input.containsKey("minVelocity")) {
            orbitSettings.minVelocity = ((Number)input.get("minVelocity")).floatValue();
        }
        if (input.containsKey("x")) {
            orbitSettings.staticPositionX = ((Number)input.get("x")).floatValue();
        }
        if (input.containsKey("y")) {
            orbitSettings.staticPositionY = ((Number)input.get("y")).floatValue();
        }
        return orbitSettings;
    }
}

